/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.storage;

import com.google.common.base.Preconditions;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.repository.storage.Component;
import org.sonatype.nexus.repository.storage.ComponentDecorator;
import org.sonatype.nexus.repository.storage.DefaultComponent;

@Singleton
@Named
public class ComponentFactory {
    private final Set<ComponentDecorator> componentDecorators;

    @Inject
    public ComponentFactory(Set<ComponentDecorator> componentDecorators) {
        this.componentDecorators = (Set)Preconditions.checkNotNull(componentDecorators);
    }

    public Component createComponent() {
        Component component = new DefaultComponent();
        for (ComponentDecorator componentDecorator : this.componentDecorators) {
            component = componentDecorator.decorate(component);
        }
        return component;
    }
}

