/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.storage;

import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.common.app.ManagedLifecycle;
import org.sonatype.nexus.common.stateguard.StateGuardLifecycleSupport;
import org.sonatype.nexus.selector.CselValidator;
import org.sonatype.nexus.selector.SelectorManager;

@Named
@ManagedLifecycle(phase=ManagedLifecycle.Phase.TASKS)
@Singleton
public class ContentSelectorUpgradeManager
extends StateGuardLifecycleSupport {
    private final CselValidator cselValidator;
    private final SelectorManager selectorManager;

    @Inject
    public ContentSelectorUpgradeManager(CselValidator cselValidator, SelectorManager selectorManager) {
        this.cselValidator = cselValidator;
        this.selectorManager = selectorManager;
    }

    protected void doStart() throws Exception {
        this.selectorManager.browseJexl().forEach(config -> {
            String expression = (String)config.getAttributes().get("expression");
            String name = config.getName();
            this.log.debug("Attempting to upgrade jexl content selector to csel, expression={}", (Object)expression);
            try {
                if (this.cselValidator.validate(expression)) {
                    config.setType("csel");
                    this.selectorManager.update(config);
                } else {
                    this.log.warn("Could not convert deprecated jexl content selector into csel content selector with name={}, expression={}", (Object)name, (Object)expression);
                }
            }
            catch (Exception e) {
                this.log.warn("Failed to parse jexl content selector for conversion to csel content selector with name={}, expression={}", new Object[]{name, expression, this.log.isDebugEnabled() ? e : null});
            }
        });
    }
}

