/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.storage;

import com.google.common.base.Preconditions;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.storage.ContentValidator;
import org.sonatype.nexus.repository.storage.DefaultContentValidator;

@Singleton
@Named
public class ContentValidatorSelector
extends ComponentSupport {
    private final Map<String, ContentValidator> contentValidators;
    private final DefaultContentValidator defaultContentValidator;

    @Inject
    public ContentValidatorSelector(Map<String, ContentValidator> contentValidators, DefaultContentValidator defaultContentValidator) {
        this.contentValidators = (Map)Preconditions.checkNotNull(contentValidators);
        this.defaultContentValidator = (DefaultContentValidator)Preconditions.checkNotNull((Object)defaultContentValidator);
    }

    @Nonnull
    public ContentValidator validator(Repository repository) {
        Preconditions.checkNotNull((Object)repository);
        String format = repository.getFormat().getValue();
        this.log.trace("Looking for content validator for format: {}", (Object)format);
        ContentValidator contentValidator = this.contentValidators.get(format);
        if (contentValidator == null) {
            return this.defaultContentValidator;
        }
        return contentValidator;
    }
}

