/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.storage;

import javax.inject.Inject;
import javax.inject.Named;
import org.sonatype.nexus.common.app.VersionComparator;
import org.sonatype.nexus.repository.storage.BrowseNode;
import org.sonatype.nexus.repository.storage.BrowseNodeComparator;

@Named(value="default")
public class DefaultBrowseNodeComparator
implements BrowseNodeComparator {
    public static final String NAME = "default";
    private final VersionComparator versionComparator;
    private static final int TYPE_COMPONENT = 1;
    private static final int TYPE_FOLDER = 2;
    private static final int TYPE_ASSET = 3;

    @Inject
    public DefaultBrowseNodeComparator(VersionComparator versionComparator) {
        this.versionComparator = versionComparator;
    }

    @Override
    public int compare(BrowseNode o1, BrowseNode o2) {
        int o1Type = this.getType(o1);
        int o2Type = this.getType(o2);
        if (o1Type == 1 && o2Type == 1) {
            try {
                return this.versionComparator.compare(o1.getName(), o2.getName());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                return 0;
            }
        }
        if (o1Type == o2Type) {
            return o1.getName().compareToIgnoreCase(o2.getName());
        }
        return Integer.compare(o1Type, o2Type);
    }

    protected int getType(BrowseNode browseNode) {
        if (browseNode.getComponentId() != null) {
            return 1;
        }
        if (browseNode.getAssetId() != null) {
            return 3;
        }
        return 2;
    }
}

