/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.storage;

import java.util.Collections;
import java.util.List;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.common.entity.DetachedEntityId;
import org.sonatype.nexus.common.entity.EntityId;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.storage.Component;
import org.sonatype.nexus.repository.storage.ComponentFinder;
import org.sonatype.nexus.repository.storage.StorageFacet;
import org.sonatype.nexus.repository.storage.StorageTx;

@Singleton
@Named
public class DefaultComponentFinder
implements ComponentFinder {
    public static final String DEFAULT_COMPONENT_FINDER_KEY = "default";

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public List<Component> findMatchingComponents(Repository repository, String componentId, String componentGroup, String componentName, String componentVersion) {
        if (repository == null) return Collections.emptyList();
        if (componentId == null) return Collections.emptyList();
        if (componentId.isEmpty()) {
            return Collections.emptyList();
        }
        Throwable throwable = null;
        Object var7_8 = null;
        try {
            List<Component> list;
            StorageTx storageTx = (StorageTx)repository.facet(StorageFacet.class).txSupplier().get();
            try {
                storageTx.begin();
                Component component = storageTx.findComponent((EntityId)new DetachedEntityId(componentId));
                if (component != null) {
                    list = Collections.singletonList(component);
                    return list;
                }
                return Collections.emptyList();
            }
            catch (Throwable throwable2) {
                throw throwable2;
            }
            finally {
                if (storageTx == null) return list;
                storageTx.close();
            }
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
                throw throwable;
            }
            if (throwable == throwable3) throw throwable;
            throwable.addSuppressed(throwable3);
            throw throwable;
        }
    }
}

