/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.storage;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.BooleanSupplier;
import javax.inject.Named;
import org.sonatype.nexus.common.entity.EntityId;
import org.sonatype.nexus.common.stateguard.Guarded;
import org.sonatype.nexus.repository.FacetSupport;
import org.sonatype.nexus.repository.storage.Asset;
import org.sonatype.nexus.repository.storage.Component;
import org.sonatype.nexus.repository.storage.ComponentMaintenance;
import org.sonatype.nexus.repository.storage.StorageFacet;
import org.sonatype.nexus.repository.storage.StorageTx;
import org.sonatype.nexus.repository.transaction.TransactionalDeleteBlob;
import org.sonatype.nexus.transaction.UnitOfWork;

@Named
public class DefaultComponentMaintenanceImpl
extends FacetSupport
implements ComponentMaintenance {
    @Override
    public Set<String> deleteComponent(EntityId componentId) {
        return this.deleteComponent(componentId, true);
    }

    @Override
    public Set<String> deleteComponent(EntityId componentId, boolean deleteBlobs) {
        Preconditions.checkNotNull((Object)componentId);
        UnitOfWork.begin(this.getRepository().facet(StorageFacet.class).txSupplier());
        try {
            Set<String> set = this.deleteComponentTx(componentId, deleteBlobs);
            return set;
        }
        finally {
            UnitOfWork.end();
        }
    }

    @TransactionalDeleteBlob
    protected Set<String> deleteComponentTx(EntityId componentId, boolean deleteBlobs) {
        StorageTx tx = (StorageTx)UnitOfWork.currentTx();
        Component component = tx.findComponentInBucket(componentId, tx.findBucket(this.getRepository()));
        if (component == null) {
            return Collections.emptySet();
        }
        this.log.debug("Deleting component: {}", (Object)component.toStringExternal());
        return tx.deleteComponent(component, deleteBlobs);
    }

    @Override
    @Guarded(by={"STARTED"})
    public Set<String> deleteAsset(EntityId assetId) {
        return this.deleteAsset(assetId, true);
    }

    @Override
    @Guarded(by={"STARTED"})
    public Set<String> deleteAsset(EntityId assetId, boolean deleteBlob) {
        Preconditions.checkNotNull((Object)assetId);
        UnitOfWork.begin(this.getRepository().facet(StorageFacet.class).txSupplier());
        try {
            Set<String> set = this.deleteAssetTx(assetId, deleteBlob);
            return set;
        }
        finally {
            UnitOfWork.end();
        }
    }

    @Override
    public long deleteComponents(Iterable<EntityId> components, BooleanSupplier cancelledCheck, int batchSize) {
        Preconditions.checkNotNull(components);
        Preconditions.checkNotNull((Object)cancelledCheck);
        UnitOfWork.beginBatch(this.getRepository().facet(StorageFacet.class).txSupplier());
        long count = 0L;
        try {
            Iterable split = Iterables.partition(components, (int)batchSize);
            for (List entityIds : split) {
                if (cancelledCheck.getAsBoolean()) {
                    break;
                }
                count += this.doBatchDelete(entityIds, cancelledCheck);
            }
        }
        finally {
            UnitOfWork.end();
        }
        this.after();
        return count;
    }

    @TransactionalDeleteBlob
    protected long deleteComponentBatch(Iterable<EntityId> components, BooleanSupplier cancelledCheck) {
        long count = 0L;
        for (EntityId component : components) {
            if (cancelledCheck.getAsBoolean()) continue;
            try {
                this.deleteComponentTx(component, true);
                this.log.debug("Component with ID '{}' deleted from repository {}", (Object)component, (Object)this.getRepository());
                ++count;
            }
            catch (Exception e) {
                this.log.debug("Unable to delete component with ID {}", (Object)component, (Object)e);
            }
        }
        return count;
    }

    @TransactionalDeleteBlob
    protected Set<String> deleteAssetTx(EntityId assetId, boolean deleteBlob) {
        StorageTx tx = (StorageTx)UnitOfWork.currentTx();
        Asset asset = tx.findAsset(assetId, tx.findBucket(this.getRepository()));
        if (asset == null) {
            return Collections.emptySet();
        }
        this.log.info("Deleting asset: {}", (Object)asset);
        tx.deleteAsset(asset, deleteBlob);
        return Collections.singleton(asset.name());
    }

    protected long doBatchDelete(List<EntityId> entityIds, BooleanSupplier cancelledCheck) {
        return this.deleteComponentBatch(entityIds, cancelledCheck);
    }

    @Override
    public void after() {
    }
}

