/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.storage;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.base.Supplier;
import com.google.common.collect.Sets;
import com.google.common.net.MediaType;
import java.io.IOException;
import java.io.InputStream;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.mime.MimeRulesSource;
import org.sonatype.nexus.mime.MimeSupport;
import org.sonatype.nexus.repository.InvalidContentException;
import org.sonatype.nexus.repository.storage.ContentValidator;

@Named(value="default")
@Singleton
public class DefaultContentValidator
extends ComponentSupport
implements ContentValidator {
    public static final String NAME = "default";
    private final MimeSupport mimeSupport;

    @Inject
    public DefaultContentValidator(MimeSupport mimeSupport) {
        this.mimeSupport = (MimeSupport)Preconditions.checkNotNull((Object)mimeSupport);
    }

    @Override
    @Nonnull
    public String determineContentType(boolean strictContentTypeValidation, Supplier<InputStream> contentSupplier, @Nullable MimeRulesSource mimeRulesSource, @Nullable String contentName, @Nullable String declaredContentType) throws IOException {
        Preconditions.checkNotNull(contentSupplier);
        String declaredBaseContentType = this.mediaTypeWithoutParameters(declaredContentType);
        LinkedHashSet<String> contentDetectedMimeTypes = new LinkedHashSet<String>();
        Throwable throwable = null;
        Object var9_10 = null;
        try (InputStream is = (InputStream)contentSupplier.get();){
            contentDetectedMimeTypes.addAll(this.mimeSupport.detectMimeTypes(is, contentName));
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        this.adjustIfHtml(contentDetectedMimeTypes);
        this.log.debug("Mime support detects {} as {}", (Object)contentName, contentDetectedMimeTypes);
        if (strictContentTypeValidation && this.isUnknown(contentDetectedMimeTypes)) {
            throw new InvalidContentException("Content type could not be determined: " + contentName);
        }
        LinkedHashSet<String> nameAssumedMimeTypes = new LinkedHashSet<String>();
        if (contentName != null) {
            nameAssumedMimeTypes.addAll(this.mimeSupport.guessMimeTypesListFromPath(contentName, new MimeRulesSource[]{mimeRulesSource != null ? mimeRulesSource : MimeRulesSource.NOOP}));
            this.adjustIfHtml(nameAssumedMimeTypes);
            this.log.debug("Mime support assumes {} as {}", (Object)contentName, nameAssumedMimeTypes);
            if (!this.isUnknown(nameAssumedMimeTypes)) {
                Sets.SetView intersection = Sets.intersection(contentDetectedMimeTypes, nameAssumedMimeTypes);
                this.log.debug("content/name types intersection {}", (Object)intersection);
                if (strictContentTypeValidation && intersection.isEmpty()) {
                    throw new InvalidContentException(String.format("Detected content type %s, but expected %s: %s", contentDetectedMimeTypes, nameAssumedMimeTypes, contentName));
                }
            }
        }
        String finalContentType = !this.isUnknown(nameAssumedMimeTypes) ? (String)nameAssumedMimeTypes.iterator().next() : (!this.isUnknown(contentDetectedMimeTypes) ? (String)contentDetectedMimeTypes.iterator().next() : (!Strings.isNullOrEmpty((String)declaredBaseContentType) ? declaredBaseContentType : "application/octet-stream"));
        this.log.debug("Content {} declared as {}, determined as {}", new Object[]{contentName, declaredContentType, finalContentType});
        return finalContentType;
    }

    @Nullable
    private String mediaTypeWithoutParameters(String declaredMediaType) {
        if (Strings.isNullOrEmpty((String)declaredMediaType)) {
            return null;
        }
        try {
            MediaType mediaType = MediaType.parse((String)declaredMediaType);
            return mediaType.withoutParameters().toString();
        }
        catch (IllegalArgumentException e) {
            int idx = declaredMediaType.indexOf(59);
            if (idx >= 0) {
                String parsedDeclaredMediaType = declaredMediaType.substring(0, idx);
                this.log.debug("Invalid declared contentType {} will retry with {}", new Object[]{declaredMediaType, parsedDeclaredMediaType, e});
                return this.mediaTypeWithoutParameters(parsedDeclaredMediaType);
            }
            throw new InvalidContentException("Content type could not be determined: " + declaredMediaType, e);
        }
    }

    private boolean isUnknown(Set<String> mimeTypes) {
        return mimeTypes.isEmpty() || mimeTypes.size() == 1 && mimeTypes.contains("application/octet-stream");
    }

    private void adjustIfHtml(Set<String> mimeTypes) {
        if (mimeTypes.contains(MediaType.HTML_UTF_8.withoutParameters().toString()) || mimeTypes.contains(MediaType.XHTML_UTF_8.withoutParameters().toString())) {
            mimeTypes.add("text/html");
        }
    }
}

