/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.storage;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.Maps;
import java.util.Collections;
import java.util.Map;

public class Query {
    private final String where;
    private final String suffix;
    private final Map<String, Object> parameters;

    public static Builder builder() {
        return new Builder();
    }

    private Query(String where, String suffix, Map<String, Object> parameters) {
        this.where = where;
        this.suffix = suffix;
        this.parameters = parameters;
    }

    public String getWhere() {
        return this.where;
    }

    public Map<String, Object> getParameters() {
        return this.parameters;
    }

    public String getQuerySuffix() {
        return this.suffix;
    }

    /* synthetic */ Query(String string, String string2, Map map, Query query) {
        this(string, string2, map);
    }

    public static class Builder {
        private final StringBuilder where = new StringBuilder();
        private final Map<String, Object> parameters = Maps.newHashMap();
        private final StringBuilder suffix = new StringBuilder();
        private int parameterNumber;

        private Builder() {
        }

        public Builder where(String where) {
            this.where.append(where);
            return this;
        }

        public Builder eq(Object value) {
            Preconditions.checkNotNull((Object)value);
            Preconditions.checkState((boolean)this.hasWhere(), (Object)"Missing where statement");
            return this.where(" = ").param(value);
        }

        public Builder and(String value) {
            Preconditions.checkNotNull((Object)value);
            Preconditions.checkState((boolean)this.hasWhere(), (Object)"Missing where statement");
            return this.where(" AND ").where(value);
        }

        public Builder or(String value) {
            Preconditions.checkNotNull((Object)value);
            Preconditions.checkState((boolean)this.hasWhere(), (Object)"Missing where statement");
            return this.where(" OR ").where(value);
        }

        public Builder isNull() {
            Preconditions.checkState((boolean)this.hasWhere(), (Object)"Missing where statement");
            return this.where(" IS NULL ");
        }

        public Builder isNotNull() {
            Preconditions.checkState((boolean)this.hasWhere(), (Object)"Missing where statement");
            return this.where(" IS NOT NULL ");
        }

        public Builder like(Object value) {
            Preconditions.checkNotNull((Object)value);
            Preconditions.checkState((boolean)this.hasWhere(), (Object)"Missing where statement");
            return this.where(" LIKE ").param(value);
        }

        public boolean hasWhere() {
            return this.clean(this.where) != null;
        }

        public Builder param(Object value) {
            return this.param("p", value);
        }

        private Builder param(String parameterName, Object value) {
            String mangledName = String.valueOf((String)Preconditions.checkNotNull((Object)parameterName)) + this.parameterNumber++;
            this.parameters.put(mangledName, value);
            this.where(":" + mangledName);
            return this;
        }

        public Builder suffix(String suffix) {
            this.suffix.append(suffix);
            return this;
        }

        public Query build() {
            StringBuilder str = this.where;
            return new Query(this.clean(str), this.clean(this.suffix), Collections.unmodifiableMap(this.parameters), null);
        }

        private String clean(StringBuilder str) {
            return Strings.emptyToNull((String)str.toString().trim());
        }
    }
}

