/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.storage;

import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.hash.HashCode;
import java.io.Closeable;
import java.io.InputStream;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonatype.nexus.blobstore.api.Blob;
import org.sonatype.nexus.blobstore.api.BlobStore;
import org.sonatype.nexus.blobstore.api.BlobStoreException;
import org.sonatype.nexus.common.hash.HashAlgorithm;

public class TempBlob
implements Closeable,
Supplier<InputStream> {
    private static final Logger log = LoggerFactory.getLogger(TempBlob.class);
    private final Blob blob;
    private final Map<HashAlgorithm, HashCode> hashes;
    private final boolean hashesVerified;
    private final BlobStore blobStore;

    public TempBlob(Blob blob, Map<HashAlgorithm, HashCode> hashes, boolean hashesVerified, BlobStore blobStore) {
        this.blob = (Blob)Preconditions.checkNotNull((Object)blob);
        this.hashes = (Map)Preconditions.checkNotNull(hashes);
        this.hashesVerified = hashesVerified;
        this.blobStore = (BlobStore)Preconditions.checkNotNull((Object)blobStore);
    }

    public Blob getBlob() {
        return this.blob;
    }

    public Map<HashAlgorithm, HashCode> getHashes() {
        return this.hashes;
    }

    public boolean getHashesVerified() {
        return this.hashesVerified;
    }

    @Override
    public void close() {
        try {
            this.blobStore.deleteHard(this.blob.getId());
        }
        catch (BlobStoreException e) {
            log.debug("Unable to delete blob {} in blob store {}", new Object[]{this.blob.getId(), this.blobStore.getBlobStoreConfiguration().getName(), e});
        }
    }

    public InputStream get() {
        return this.blob.getInputStream();
    }
}

