/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.storage.internal;

import com.google.common.eventbus.AllowConcurrentEvents;
import com.google.common.eventbus.Subscribe;
import java.util.Map;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.audit.AuditData;
import org.sonatype.nexus.audit.AuditorSupport;
import org.sonatype.nexus.common.event.EventAware;
import org.sonatype.nexus.repository.storage.Asset;
import org.sonatype.nexus.repository.storage.AssetCreatedEvent;
import org.sonatype.nexus.repository.storage.AssetDeletedEvent;
import org.sonatype.nexus.repository.storage.AssetEvent;
import org.sonatype.nexus.repository.storage.AssetUpdatedEvent;

@Named
@Singleton
public class AssetAuditor
extends AuditorSupport
implements EventAware {
    public static final String DOMAIN = "repository.asset";

    public AssetAuditor() {
        this.registerType(AssetCreatedEvent.class, "created");
        this.registerType(AssetDeletedEvent.class, "deleted");
        this.registerType(AssetUpdatedEvent.class, "updated");
    }

    @Subscribe
    @AllowConcurrentEvents
    public void on(AssetEvent event) {
        if (this.isRecording() && event.isLocal()) {
            Asset asset = event.getAsset();
            AuditData data = new AuditData();
            data.setDomain(DOMAIN);
            data.setType(this.type(event.getClass()));
            data.setContext(asset.name());
            Map attributes = data.getAttributes();
            attributes.put("repository.name", event.getRepositoryName());
            attributes.put("format", asset.format());
            attributes.put("name", asset.name());
            this.record(data);
        }
    }
}

