/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.storage.internal;

import com.google.common.base.Preconditions;
import com.orientechnologies.orient.core.db.document.ODatabaseDocumentTx;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.sonatype.goodies.lifecycle.LifecycleSupport;
import org.sonatype.nexus.common.app.ManagedLifecycle;
import org.sonatype.nexus.orient.DatabaseInstance;
import org.sonatype.nexus.repository.storage.AssetEntityAdapter;
import org.sonatype.nexus.repository.storage.BucketEntityAdapter;
import org.sonatype.nexus.repository.storage.ComponentEntityAdapter;

@Named
@ManagedLifecycle(phase=ManagedLifecycle.Phase.SCHEMAS)
@Singleton
public class ComponentSchemaRegistration
extends LifecycleSupport {
    private final Provider<DatabaseInstance> databaseInstance;
    private final BucketEntityAdapter bucketEntityAdapter;
    private final ComponentEntityAdapter componentEntityAdapter;
    private final AssetEntityAdapter assetEntityAdapter;

    @Inject
    public ComponentSchemaRegistration(@Named(value="component") Provider<DatabaseInstance> databaseInstance, BucketEntityAdapter bucketEntityAdapter, ComponentEntityAdapter componentEntityAdapter, AssetEntityAdapter assetEntityAdapter) {
        this.databaseInstance = (Provider)Preconditions.checkNotNull(databaseInstance);
        this.bucketEntityAdapter = (BucketEntityAdapter)((Object)Preconditions.checkNotNull((Object)((Object)bucketEntityAdapter)));
        this.componentEntityAdapter = (ComponentEntityAdapter)((Object)Preconditions.checkNotNull((Object)((Object)componentEntityAdapter)));
        this.assetEntityAdapter = (AssetEntityAdapter)((Object)Preconditions.checkNotNull((Object)((Object)assetEntityAdapter)));
    }

    protected void doStart() throws Exception {
        Throwable throwable = null;
        Object var2_3 = null;
        try (ODatabaseDocumentTx db = ((DatabaseInstance)this.databaseInstance.get()).connect();){
            this.bucketEntityAdapter.register(db);
            this.componentEntityAdapter.register(db);
            this.assetEntityAdapter.register(db);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }
}

