/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.storage.internal;

import com.google.common.base.Preconditions;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.sonatype.nexus.blobstore.api.BlobStore;
import org.sonatype.nexus.common.app.ManagedLifecycle;
import org.sonatype.nexus.common.entity.Entity;
import org.sonatype.nexus.common.stateguard.Guarded;
import org.sonatype.nexus.common.stateguard.StateGuardLifecycleSupport;
import org.sonatype.nexus.orient.DatabaseInstance;
import org.sonatype.nexus.orient.transaction.OrientTransactional;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.storage.Bucket;
import org.sonatype.nexus.repository.storage.BucketDeleter;
import org.sonatype.nexus.repository.storage.BucketEntityAdapter;
import org.sonatype.nexus.repository.storage.StorageFacetManager;

@Named
@ManagedLifecycle(phase=ManagedLifecycle.Phase.SERVICES)
@Singleton
public class StorageFacetManagerImpl
extends StateGuardLifecycleSupport
implements StorageFacetManager {
    private final Provider<DatabaseInstance> databaseInstanceProvider;
    private final BucketEntityAdapter bucketEntityAdapter;
    private final BucketDeleter bucketDeleter;

    @Inject
    public StorageFacetManagerImpl(@Named(value="component") Provider<DatabaseInstance> databaseInstanceProvider, BucketEntityAdapter bucketEntityAdapter, BucketDeleter bucketDeleter) {
        this.databaseInstanceProvider = (Provider)Preconditions.checkNotNull(databaseInstanceProvider);
        this.bucketEntityAdapter = (BucketEntityAdapter)((Object)Preconditions.checkNotNull((Object)((Object)bucketEntityAdapter)));
        this.bucketDeleter = (BucketDeleter)((Object)Preconditions.checkNotNull((Object)((Object)bucketDeleter)));
    }

    @Override
    @Guarded(by={"STARTED"})
    public void enqueueDeletion(Repository repository, BlobStore blobStore, Bucket bucket) {
        Preconditions.checkNotNull((Object)repository);
        Preconditions.checkNotNull((Object)blobStore);
        Preconditions.checkNotNull((Object)((Object)bucket));
        String generatedRepositoryName = String.valueOf(repository.getName()) + '$' + UUID.randomUUID();
        bucket.setRepositoryName(generatedRepositoryName);
        bucket.attributes().set("pendingDeletion", (Object)true);
        this.updateBucket(bucket);
    }

    @Override
    @Guarded(by={"STARTED"})
    public long performDeletions() {
        List<Bucket> buckets = this.findBucketsForDeletion();
        return buckets.stream().filter(bucket -> {
            try {
                this.log.info("Deleting bucket for repository {}", (Object)bucket.getRepositoryName());
                this.deleteBucket((Bucket)((Object)bucket));
                return true;
            }
            catch (Exception e) {
                this.log.warn("Unable to delete bucket with repository name {}, will require manual cleanup", (Object)bucket.getRepositoryName(), (Object)e);
                return false;
            }
        }).count();
    }

    private List<Bucket> findBucketsForDeletion() {
        return (List)OrientTransactional.inTx(this.databaseInstanceProvider).call(db -> StreamSupport.stream(this.bucketEntityAdapter.browse(db).spliterator(), false).filter(bucket -> bucket.attributes().contains("pendingDeletion")).collect(Collectors.toList()));
    }

    protected void deleteBucket(Bucket bucket) throws Exception {
        this.bucketDeleter.deleteBucket(bucket);
    }

    protected void updateBucket(Bucket bucket) {
        OrientTransactional.inTxRetry(this.databaseInstanceProvider).run(db -> this.bucketEntityAdapter.editEntity(db, (Entity)bucket));
    }
}

