/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.upgrade;

import com.google.common.base.Preconditions;
import com.orientechnologies.orient.core.command.OCommandRequest;
import com.orientechnologies.orient.core.db.document.ODatabaseDocumentTx;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.metadata.schema.OSchemaProxy;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.sql.OCommandSQL;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.sonatype.nexus.common.upgrade.Upgrades;
import org.sonatype.nexus.orient.DatabaseInstance;
import org.sonatype.nexus.orient.DatabaseUpgradeSupport;
import org.sonatype.nexus.orient.OClassNameBuilder;

@Named
@Singleton
@Upgrades(model="component", from="1.2", to="1.3")
public class ComponentDatabaseUpgrade_1_3
extends DatabaseUpgradeSupport {
    static final String ASSET_CLASS = new OClassNameBuilder().type("asset").build();
    static final String P_LAST_ACCESSED = "last_accessed";
    static final String ALTER_ASSET_LAST_ACCESSED = "alter property asset.last_accessed name last_downloaded";
    private final Provider<DatabaseInstance> componentDatabaseInstance;

    @Inject
    public ComponentDatabaseUpgrade_1_3(@Named(value="component") Provider<DatabaseInstance> componentDatabaseInstance) {
        this.componentDatabaseInstance = (Provider)Preconditions.checkNotNull(componentDatabaseInstance);
    }

    public void apply() throws Exception {
        if (ComponentDatabaseUpgrade_1_3.hasSchemaClass(this.componentDatabaseInstance, (String)ASSET_CLASS)) {
            this.createAssetBlobCreatedField();
            this.createAssetBlobUpdatedField();
            this.renameAssetLastAccessedField();
        }
    }

    private void createAssetBlobCreatedField() {
        Throwable throwable = null;
        Object var2_3 = null;
        try (ODatabaseDocumentTx db = ((DatabaseInstance)this.componentDatabaseInstance.get()).connect();){
            this.maybeCreateProperty(this.getAssetDbClass(db), "blob_created", OType.DATETIME);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private void createAssetBlobUpdatedField() {
        Throwable throwable = null;
        Object var2_3 = null;
        try (ODatabaseDocumentTx db = ((DatabaseInstance)this.componentDatabaseInstance.get()).connect();){
            this.maybeCreateProperty(this.getAssetDbClass(db), "blob_updated", OType.DATETIME);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private void renameAssetLastAccessedField() {
        Throwable throwable = null;
        Object var2_3 = null;
        try (ODatabaseDocumentTx db = ((DatabaseInstance)this.componentDatabaseInstance.get()).connect();){
            OClass assetClass = this.getAssetDbClass(db);
            if (assetClass.existsProperty(P_LAST_ACCESSED)) {
                db.command((OCommandRequest)new OCommandSQL(ALTER_ASSET_LAST_ACCESSED)).execute(new Object[0]);
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private OClass getAssetDbClass(ODatabaseDocumentTx db) {
        OSchemaProxy schema = db.getMetadata().getSchema();
        return schema.getClass(ASSET_CLASS);
    }

    private void maybeCreateProperty(OClass oClass, String property, OType oType) {
        if (!oClass.existsProperty(property)) {
            oClass.createProperty(property, oType);
        }
    }
}

