/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.upgrade;

import com.google.common.base.Preconditions;
import com.orientechnologies.orient.core.metadata.schema.OType;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.sonatype.nexus.common.upgrade.Upgrades;
import org.sonatype.nexus.orient.DatabaseInstance;
import org.sonatype.nexus.orient.DatabaseUpgradeSupport;
import org.sonatype.nexus.orient.OClassNameBuilder;

@Named
@Singleton
@Upgrades(model="component", from="1.6", to="1.7")
public class ComponentDatabaseUpgrade_1_7
extends DatabaseUpgradeSupport {
    private static final String ASSET = new OClassNameBuilder().type("asset").build();
    private static final String BROWSE_NODE = new OClassNameBuilder().type("browse_node").build();
    private final Provider<DatabaseInstance> componentDatabaseInstance;

    @Inject
    public ComponentDatabaseUpgrade_1_7(@Named(value="component") Provider<DatabaseInstance> componentDatabaseInstance) {
        this.componentDatabaseInstance = (Provider)Preconditions.checkNotNull(componentDatabaseInstance);
    }

    public void apply() throws Exception {
        ComponentDatabaseUpgrade_1_7.withDatabaseAndClass(this.componentDatabaseInstance, (String)BROWSE_NODE, (db, table) -> db.getMetadata().getSchema().dropClass(BROWSE_NODE));
        ComponentDatabaseUpgrade_1_7.withDatabaseAndClass(this.componentDatabaseInstance, (String)ASSET, (db, table) -> {
            if (!table.existsProperty("created_by")) {
                table.createProperty("created_by", OType.STRING);
            }
            if (!table.existsProperty("created_by_ip")) {
                table.createProperty("created_by_ip", OType.STRING);
            }
        });
    }
}

