/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.upgrade;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.orientechnologies.orient.core.collate.OCaseInsensitiveCollate;
import com.orientechnologies.orient.core.collate.OCollate;
import com.orientechnologies.orient.core.db.document.ODatabaseDocumentTx;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.query.OQuery;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.sql.query.OSQLSynchQuery;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.sonatype.nexus.blobstore.api.BlobRef;
import org.sonatype.nexus.common.upgrade.DependsOn;
import org.sonatype.nexus.common.upgrade.Upgrades;
import org.sonatype.nexus.orient.DatabaseInstance;
import org.sonatype.nexus.orient.DatabaseUpgradeSupport;
import org.sonatype.nexus.orient.OClassNameBuilder;

@Named
@Singleton
@Upgrades(model="config", from="1.1", to="1.2")
@DependsOn(model="component", version="1.0", checkpoint=true)
public class ConfigDatabaseUpgrade_1_2
extends DatabaseUpgradeSupport {
    static final String DB_CLASS = new OClassNameBuilder().prefix("repository").type("blobstore").build();
    private static final String P_NAME = "name";
    private static final String BLOBSTORE_NAME_DETAIL_FIELD = "blobstoreName";
    private static final String JOB_DATA_MAP = "jobDataMap";
    private static final String ATTRIBUTES = "attributes";
    private static final String BLOB_STORE_NAME = "blobStoreName";
    private final Provider<DatabaseInstance> componentDatabaseInstance;
    private final Provider<DatabaseInstance> configDatabaseInstance;

    @Inject
    public ConfigDatabaseUpgrade_1_2(@Named(value="config") Provider<DatabaseInstance> databaseInstance, @Named(value="component") Provider<DatabaseInstance> componentDatabaseInstance) {
        this.configDatabaseInstance = (Provider)Preconditions.checkNotNull(databaseInstance);
        this.componentDatabaseInstance = (Provider)Preconditions.checkNotNull(componentDatabaseInstance);
    }

    public void apply() throws Exception {
        if (ConfigDatabaseUpgrade_1_2.hasSchemaClass(this.configDatabaseInstance, (String)DB_CLASS)) {
            Map<String, String> renames = this.renameDuplicateBlobStores();
            if (ConfigDatabaseUpgrade_1_2.hasSchemaClass(this.configDatabaseInstance, (String)"repository")) {
                this.updateRepositoriesForRenamedBlobStores(renames);
            }
            if (ConfigDatabaseUpgrade_1_2.hasSchemaClass(this.configDatabaseInstance, (String)"quartz_job_detail")) {
                this.updateBlobStoreJobs(renames);
            }
            if (ConfigDatabaseUpgrade_1_2.hasSchemaClass(this.componentDatabaseInstance, (String)"asset")) {
                this.updateAssetBlobStoreRefs(renames);
            }
            this.upgradeSchemaToCaseInsensitiveName();
        }
    }

    @VisibleForTesting
    void updateAssetBlobStoreRefs(Map<String, String> renamedBlobStores) {
        Throwable throwable = null;
        Object var3_4 = null;
        try (ODatabaseDocumentTx db = ((DatabaseInstance)this.componentDatabaseInstance.get()).connect();){
            renamedBlobStores.forEach((originalName, newName) -> {
                this.log.debug("Searching for BlobStoreRefs, original name: {}, new name: {} ", originalName, newName);
                OSQLSynchQuery query = new OSQLSynchQuery("select from asset where blob_ref like ? and @rid > ? limit 100");
                String nameTestValue = String.valueOf(originalName) + "@%";
                List results = db.query((OQuery)query, new Object[]{nameTestValue, new ORecordId()});
                while (!results.isEmpty()) {
                    this.log.debug("Updating set of {} Refs", (Object)results.size());
                    ORID last = ((ODocument)results.get(results.size() - 1)).getIdentity();
                    results.forEach(doc -> this.updateDocWithNewName((String)originalName, (String)newName, (ODocument)doc));
                    results = db.query((OQuery)query, new Object[]{nameTestValue, last});
                }
            });
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private void updateDocWithNewName(String originalName, String newName, ODocument doc) {
        BlobRef blobRef = BlobRef.parse((String)((String)doc.field("blob_ref", String.class)));
        if (blobRef.getStore().equals(originalName)) {
            doc.field("blob_ref", (Object)new BlobRef(blobRef.getNode(), newName, blobRef.getBlob())).save();
        }
    }

    @VisibleForTesting
    void updateBlobStoreJobs(Map<String, String> renamedBlobStores) {
        Throwable throwable = null;
        Object var3_4 = null;
        try (ODatabaseDocumentTx db = ((DatabaseInstance)this.configDatabaseInstance.get()).connect();){
            StreamSupport.stream(db.browseClass("quartz_job_detail").spliterator(), false).forEach(doc -> {
                Map valueData = (Map)doc.field("value_data");
                Map<String, Object> jobDataMap = this.getJobData((ODocument)doc, valueData);
                if (jobDataMap == null) {
                    return;
                }
                String blobStoreName = (String)jobDataMap.get(BLOBSTORE_NAME_DETAIL_FIELD);
                if (renamedBlobStores.containsKey(blobStoreName)) {
                    jobDataMap.put(BLOBSTORE_NAME_DETAIL_FIELD, renamedBlobStores.get(blobStoreName));
                    doc.field("value_data", (Object)valueData).save();
                }
            });
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private Map<String, Object> getJobData(ODocument doc, Map<String, Map<String, Object>> valueData) {
        Map<String, Object> jobDataMap = valueData.get(JOB_DATA_MAP);
        if (jobDataMap == null) {
            this.log.debug("Job {} does not contain a jobDataMap, skipping.", (Object)doc);
            return null;
        }
        if (jobDataMap.get(BLOBSTORE_NAME_DETAIL_FIELD) == null) {
            this.log.debug("Job {} does not refer to a blob store, skipping.", (Object)doc);
            return null;
        }
        return jobDataMap;
    }

    @VisibleForTesting
    void upgradeSchemaToCaseInsensitiveName() {
        Throwable throwable = null;
        Object var2_3 = null;
        try (ODatabaseDocumentTx db = ((DatabaseInstance)this.configDatabaseInstance.get()).connect();){
            OClass blobStoreClass = db.getMetadata().getSchema().getClass(DB_CLASS);
            blobStoreClass.getProperty(P_NAME).setCollate((OCollate)new OCaseInsensitiveCollate());
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @VisibleForTesting
    Map<String, String> renameDuplicateBlobStores() {
        Throwable throwable = null;
        Object var2_3 = null;
        try (ODatabaseDocumentTx db = ((DatabaseInstance)this.configDatabaseInstance.get()).connect();){
            List allBlobStores = StreamSupport.stream(db.browseClass(DB_CLASS).spliterator(), false).collect(Collectors.toList());
            this.log.debug("Found {} BlobStores to check for name collisions after case-insensitivity is added.", (Object)allBlobStores.size());
            Map<String, List> toUpdate = allBlobStores.stream().collect(Collectors.toMap(doc -> doc.field(P_NAME, String.class).toString().toLowerCase(), doc -> new ArrayList<ODocument>(Collections.singletonList(doc)), (oDocuments, oDocuments2) -> {
                oDocuments.addAll(oDocuments2);
                return oDocuments;
            }));
            return toUpdate.entrySet().stream().filter(entry -> ((List)entry.getValue()).size() > 1).map(entry -> {
                if (((String)entry.getKey()).contains("@")) {
                    throw new IllegalStateException("Invalid blob store name: " + (String)entry.getKey());
                }
                this.log.debug("For lower-cased blob store name {}, {} collisions found.", entry.getKey(), (Object)((List)entry.getValue()).size());
                AtomicInteger counter = new AtomicInteger(0);
                return ((List)entry.getValue()).stream().sorted((o1, o2) -> o2.field(P_NAME, String.class).toString().compareTo((String)o1.field(P_NAME, String.class))).map(document -> this.updateDocumentNameWithModifier((ODocument)document, counter.getAndIncrement())).collect(Collectors.toList());
            }).flatMap(Collection::stream).filter(Objects::nonNull).collect(Collectors.toMap(rename -> rename.originalName, rename -> rename.newName));
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private Rename updateDocumentNameWithModifier(ODocument document, int modifier) {
        String name = (String)document.field(P_NAME, String.class);
        if (modifier == 0) {
            this.log.debug("BlobStore {} name will not be updated");
            return null;
        }
        String newName = String.valueOf(name) + "-" + Integer.toString(modifier);
        this.log.info("BlobStore {} will be renamed to {}", (Object)name, (Object)newName);
        document.field(P_NAME, (Object)newName).save();
        return new Rename(newName, name);
    }

    @VisibleForTesting
    void updateRepositoriesForRenamedBlobStores(Map<String, String> renamedBlobStores) {
        Throwable throwable = null;
        Object var3_4 = null;
        try (ODatabaseDocumentTx db = ((DatabaseInstance)this.configDatabaseInstance.get()).connect();){
            StreamSupport.stream(db.browseClass("repository").spliterator(), false).forEach(doc -> {
                String blobStoreName;
                Map storage;
                Map attributes = (Map)doc.field(ATTRIBUTES);
                if (attributes != null && (storage = (Map)attributes.get("storage")) != null && renamedBlobStores.containsKey(blobStoreName = (String)storage.get(BLOB_STORE_NAME))) {
                    storage.put(BLOB_STORE_NAME, renamedBlobStores.get(blobStoreName));
                    doc.field(ATTRIBUTES, (Object)attributes).save();
                }
            });
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @VisibleForTesting
    public static class Rename {
        final String newName;
        final String originalName;

        @VisibleForTesting
        public Rename(String newName, String originalName) {
            this.newName = newName;
            this.originalName = originalName;
        }
    }
}

