/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.upload;

import com.google.common.base.Preconditions;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.repository.rest.UploadDefinitionExtension;
import org.sonatype.nexus.repository.upload.UploadDefinition;
import org.sonatype.nexus.repository.upload.UploadFieldDefinition;
import org.sonatype.nexus.repository.upload.UploadHandler;
import org.sonatype.nexus.repository.upload.UploadRegexMap;

public abstract class UploadHandlerSupport
extends ComponentSupport
implements UploadHandler {
    private final Set<UploadDefinitionExtension> uploadDefinitionExtensions;

    public UploadHandlerSupport(Set<UploadDefinitionExtension> uploadDefinitionExtensions) {
        this.uploadDefinitionExtensions = (Set)Preconditions.checkNotNull(uploadDefinitionExtensions);
    }

    public UploadDefinition getDefinition(String format, boolean multipleUpload, List<UploadFieldDefinition> componentFields, List<UploadFieldDefinition> assetFields, UploadRegexMap regexMap) {
        List<UploadFieldDefinition> componentFieldDefinitions = Stream.concat(componentFields.stream(), this.uploadDefinitionExtensions.stream().map(UploadDefinitionExtension::contribute)).collect(Collectors.toList());
        return new UploadDefinition(format, multipleUpload, componentFieldDefinitions, assetFields, regexMap);
    }

    public UploadDefinition getDefinition(String format, boolean multipleUpload) {
        return this.getDefinition(format, multipleUpload, Collections.emptyList(), Collections.emptyList(), null);
    }
}

