/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.upload;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.sonatype.nexus.common.entity.EntityId;
import org.sonatype.nexus.repository.storage.Asset;
import org.sonatype.nexus.repository.view.Content;

public final class UploadResponse {
    private final List<String> assetPaths;
    private final List<EntityId> componentIds;

    public UploadResponse(Asset asset) {
        Preconditions.checkNotNull((Object)asset);
        this.assetPaths = Collections.singletonList(asset.name());
        this.componentIds = Optional.of(asset).map(Asset::componentId).map(Collections::singletonList).orElse(Collections.emptyList());
    }

    public UploadResponse(EntityId entityId, List<String> assetPaths) {
        this.componentIds = ImmutableList.of((Object)((EntityId)Preconditions.checkNotNull((Object)entityId)));
        this.assetPaths = (List)Preconditions.checkNotNull(assetPaths);
    }

    public UploadResponse(Content content, List<String> assetPaths) {
        this.componentIds = UploadResponse.extractComponentIds((Collection<Content>)ImmutableList.of((Object)((Content)Preconditions.checkNotNull((Object)content))));
        this.assetPaths = (List)Preconditions.checkNotNull(assetPaths);
    }

    public UploadResponse(Collection<Content> contents, List<String> assetPaths) {
        this.componentIds = UploadResponse.extractComponentIds((Collection)Preconditions.checkNotNull(contents));
        this.assetPaths = (List)Preconditions.checkNotNull(assetPaths);
    }

    @Nullable
    public EntityId getComponentId() {
        return this.componentIds.stream().findFirst().orElse(null);
    }

    public List<EntityId> getComponentIds() {
        return this.componentIds;
    }

    public List<String> getAssetPaths() {
        return this.assetPaths;
    }

    private static List<EntityId> extractComponentIds(Collection<Content> contents) {
        return contents.stream().map(UploadResponse::extractComponentId).filter(Objects::nonNull).collect(Collectors.toList());
    }

    @Nullable
    private static EntityId extractComponentId(Content content) {
        Optional<Asset> asset = Optional.ofNullable((Asset)content.getAttributes().get(Asset.class));
        return asset.map(Asset::componentId).orElse(null);
    }
}

