/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.upload.internal;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.types.HostedType;
import org.sonatype.nexus.repository.upload.ComponentUpload;
import org.sonatype.nexus.repository.upload.UploadDefinition;
import org.sonatype.nexus.repository.upload.UploadHandler;
import org.sonatype.nexus.repository.upload.UploadManager;
import org.sonatype.nexus.repository.upload.UploadResponse;
import org.sonatype.nexus.rest.ValidationErrorsException;

@Named
@Singleton
public class UploadManagerImpl
implements UploadManager {
    private List<UploadDefinition> uploadDefinitions;
    private Map<String, UploadHandler> uploadHandlers;

    @Inject
    public UploadManagerImpl(Map<String, UploadHandler> uploadHandlers) {
        this.uploadHandlers = (Map)Preconditions.checkNotNull(uploadHandlers);
        this.uploadDefinitions = Collections.unmodifiableList(uploadHandlers.values().stream().map(handler -> handler.getDefinition()).collect(Collectors.toList()));
    }

    @Override
    public Collection<UploadDefinition> getAvailableDefinitions() {
        return this.uploadDefinitions;
    }

    @Override
    public UploadResponse handle(Repository repository, ComponentUpload upload) throws IOException {
        Preconditions.checkNotNull((Object)repository);
        Preconditions.checkNotNull((Object)upload);
        UploadHandler uploadHandler = this.getUploadHandler(repository);
        return uploadHandler.handle(repository, uploadHandler.getValidatingComponentUpload(upload).getComponentUpload());
    }

    @Override
    public UploadDefinition getByFormat(String format) {
        Preconditions.checkNotNull((Object)format);
        UploadHandler handler = this.uploadHandlers.get(format);
        return handler != null ? handler.getDefinition() : null;
    }

    private UploadHandler getUploadHandler(Repository repository) {
        if (!(repository.getType() instanceof HostedType)) {
            throw new ValidationErrorsException(String.format("Uploading components to a '%s' type repository is unsupported, must be '%s'", repository.getType().getValue(), "hosted"));
        }
        String repositoryFormat = repository.getFormat().toString();
        UploadHandler uploadHandler = this.uploadHandlers.get(repositoryFormat);
        if (uploadHandler == null) {
            throw new ValidationErrorsException(String.format("Uploading components to '%s' repositories is unsupported", repositoryFormat));
        }
        return uploadHandler;
    }
}

