/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.view;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.ListIterator;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonatype.nexus.common.collect.AttributesMap;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.view.Handler;
import org.sonatype.nexus.repository.view.Request;
import org.sonatype.nexus.repository.view.Response;
import org.sonatype.nexus.repository.view.Route;

public class Context {
    private static final Logger log = LoggerFactory.getLogger(Context.class);
    private final AttributesMap attributes = new AttributesMap();
    private final Repository repository;
    private final Request request;
    private ListIterator<Handler> handlers;

    public Context(Repository repository, Request request) {
        this.repository = (Repository)Preconditions.checkNotNull((Object)repository);
        this.request = (Request)Preconditions.checkNotNull((Object)request);
    }

    public AttributesMap getAttributes() {
        return this.attributes;
    }

    public Repository getRepository() {
        return this.repository;
    }

    public Request getRequest() {
        return this.request;
    }

    @Nonnull
    public Response proceed() throws Exception {
        Preconditions.checkState((this.handlers != null ? 1 : 0) != 0, (Object)"Context not started");
        Preconditions.checkState((boolean)this.handlers.hasNext(), (Object)"End of handler chain");
        Handler handler = this.handlers.next();
        try {
            log.debug("Proceeding: {}", (Object)handler);
            Response response = handler.handle(this);
            return response;
        }
        finally {
            if (this.handlers.hasPrevious()) {
                this.handlers.previous();
            }
        }
    }

    public void insertHandler(Handler handler) {
        Preconditions.checkNotNull((Object)handler);
        this.handlers.add(handler);
        this.handlers.previous();
    }

    @Nonnull
    Response start(Route route) throws Exception {
        Preconditions.checkNotNull((Object)route);
        Preconditions.checkState((this.handlers == null ? 1 : 0) != 0, (Object)"Already started");
        log.debug("Starting: {}", (Object)route);
        this.handlers = new ArrayList<Handler>(route.getHandlers()).listIterator();
        return this.proceed();
    }
}

