/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.view;

import com.google.common.base.Preconditions;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.sonatype.nexus.common.collect.AttributesMap;
import org.sonatype.nexus.repository.view.Headers;
import org.sonatype.nexus.repository.view.Parameters;
import org.sonatype.nexus.repository.view.PartPayload;
import org.sonatype.nexus.repository.view.Payload;

public class Request {
    private final AttributesMap attributes;
    private final Headers headers;
    private final String action;
    private final String path;
    private final Parameters parameters;
    private final Payload payload;
    private final boolean multipart;
    private final Iterable<PartPayload> multiPayloads;

    private Request(AttributesMap attributes, Headers headers, String action, String path, Parameters parameters, @Nullable Payload payload, boolean multipart, @Nullable Iterable<PartPayload> multiPayloads) {
        this.attributes = (AttributesMap)Preconditions.checkNotNull((Object)attributes);
        this.headers = (Headers)((Object)Preconditions.checkNotNull((Object)((Object)headers)));
        this.action = (String)Preconditions.checkNotNull((Object)action);
        this.path = (String)Preconditions.checkNotNull((Object)path);
        this.parameters = (Parameters)((Object)Preconditions.checkNotNull((Object)((Object)parameters)));
        this.payload = payload;
        this.multipart = multipart;
        this.multiPayloads = multiPayloads;
    }

    public AttributesMap getAttributes() {
        return this.attributes;
    }

    public Headers getHeaders() {
        return this.headers;
    }

    public String getAction() {
        return this.action;
    }

    public String getPath() {
        return this.path;
    }

    public Parameters getParameters() {
        return this.parameters;
    }

    @Nullable
    public Payload getPayload() {
        return this.payload;
    }

    public boolean isMultipart() {
        return this.multipart;
    }

    @Nullable
    public Iterable<PartPayload> getMultiparts() {
        return this.multiPayloads;
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + "{" + "action='" + this.action + '\'' + ", path='" + this.path + '\'' + ", parameters=" + (Object)((Object)this.parameters) + ", payload=" + this.payload + ", multipart=" + this.multipart + '}';
    }

    /* synthetic */ Request(AttributesMap attributesMap, Headers headers, String string, String string2, Parameters parameters, Payload payload, boolean bl, Iterable iterable, Request request) {
        this(attributesMap, headers, string, string2, parameters, payload, bl, iterable);
    }

    public static class Builder {
        private AttributesMap attributes;
        private Headers headers;
        private String action;
        private String path;
        private Parameters parameters;
        private Payload payload;
        private boolean multipart;
        private Iterable<PartPayload> multiparts;

        public Builder attributes(AttributesMap attributes) {
            this.attributes = attributes;
            return this;
        }

        @Nonnull
        public AttributesMap attributes() {
            if (this.attributes == null) {
                this.attributes = new AttributesMap();
            }
            return this.attributes;
        }

        public Builder attribute(String name, Object value) {
            this.attributes().set(name, value);
            return this;
        }

        public Builder headers(Headers headers) {
            this.headers = headers;
            return this;
        }

        @Nonnull
        public Headers headers() {
            if (this.headers == null) {
                this.headers = new Headers();
            }
            return this.headers;
        }

        public Builder header(String name, String ... values) {
            this.headers().set(name, values);
            return this;
        }

        public Builder action(String action) {
            this.action = action;
            return this;
        }

        public Builder path(String path) {
            this.path = path;
            return this;
        }

        public Builder parameters(Parameters parameters) {
            this.parameters = parameters;
            return this;
        }

        @Nonnull
        public Parameters parameters() {
            if (this.parameters == null) {
                this.parameters = new Parameters();
            }
            return this.parameters;
        }

        public Builder parameter(String name, String ... values) {
            this.parameters().set(name, values);
            return this;
        }

        public Builder payload(Payload payload) {
            this.payload = payload;
            return this;
        }

        public Builder multipart(boolean multipart) {
            this.multipart = multipart;
            return this;
        }

        public Builder multiparts(Iterable<PartPayload> multiparts) {
            this.multiparts = multiparts;
            this.multipart = multiparts != null;
            return this;
        }

        public Builder copy(Request request) {
            Preconditions.checkNotNull((Object)request);
            this.attributes = request.getAttributes();
            this.headers = request.getHeaders();
            this.action = request.getAction();
            this.path = request.getPath();
            this.parameters = request.getParameters();
            this.payload = request.getPayload();
            this.multipart = request.isMultipart();
            this.multiparts = request.getMultiparts();
            return this;
        }

        public Request build() {
            Preconditions.checkState((this.action != null ? 1 : 0) != 0, (Object)"Missing: action");
            Preconditions.checkState((this.path != null ? 1 : 0) != 0, (Object)"Missing: path");
            return new Request(this.attributes(), this.headers(), this.action, this.path, this.parameters(), this.payload, this.multipart, this.multiparts, null);
        }
    }
}

