/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.view;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.List;
import javax.annotation.Nonnull;
import org.sonatype.nexus.repository.view.Handler;
import org.sonatype.nexus.repository.view.Matcher;

public class Route {
    private final Matcher matcher;
    private final List<Handler> handlers;

    public Route(Matcher matcher, List<Handler> handlers) {
        this.matcher = (Matcher)Preconditions.checkNotNull((Object)matcher, (Object)"Missing matcher");
        Preconditions.checkNotNull(handlers, (Object)"Missing handlers");
        Preconditions.checkArgument((!handlers.isEmpty() ? 1 : 0) != 0, (Object)"At least one handler is required");
        this.handlers = handlers;
    }

    @Nonnull
    public Matcher getMatcher() {
        return this.matcher;
    }

    @Nonnull
    public List<Handler> getHandlers() {
        return this.handlers;
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + "{" + "matcher=" + this.matcher + ", handlers=" + this.handlers + '}';
    }

    public static class Builder {
        private Matcher matcher;
        private List<Handler> handlers = Lists.newArrayList();

        public Builder matcher(Matcher matcher) {
            Preconditions.checkState((this.matcher == null ? 1 : 0) != 0, (Object)"Only one matcher allowed");
            this.matcher = (Matcher)Preconditions.checkNotNull((Object)matcher);
            return this;
        }

        public Builder handler(Handler handler) {
            Preconditions.checkNotNull((Object)handler);
            this.handlers.add(handler);
            return this;
        }

        public Route create() {
            return new Route(this.matcher, this.handlers);
        }
    }
}

