/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.view;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.view.Context;
import org.sonatype.nexus.repository.view.DefaultRoute;
import org.sonatype.nexus.repository.view.Handler;
import org.sonatype.nexus.repository.view.Request;
import org.sonatype.nexus.repository.view.Response;
import org.sonatype.nexus.repository.view.Route;
import org.sonatype.nexus.repository.view.ViewUtils;

public class Router
extends ComponentSupport {
    private final List<Route> routes;
    private final DefaultRoute defaultRoute;
    public static final String LOCAL_ATTRIBUTE_PREFIX = "local.attribute.";

    public Router(List<Route> routes, DefaultRoute defaultRoute) {
        this.routes = (List)Preconditions.checkNotNull(routes, (Object)"Missing routes");
        this.defaultRoute = (DefaultRoute)Preconditions.checkNotNull((Object)defaultRoute, (Object)"Missing default route");
    }

    public Response dispatch(Repository repository, Request request, @Nullable Context existingContext) throws Exception {
        Preconditions.checkNotNull((Object)repository);
        Preconditions.checkNotNull((Object)request);
        this.logRequest(request);
        Context context = this.maybeCopyContextAttributes(repository, request, existingContext);
        Route route = this.findRoute(context);
        Response response = context.start(route);
        this.logResponse(response);
        return response;
    }

    @VisibleForTesting
    Context maybeCopyContextAttributes(Repository repository, Request request, Context existingContext) {
        Context context = new Context(repository, request);
        ViewUtils.copyLocalContextAttributes(existingContext, context);
        return context;
    }

    private void logRequest(Request request) {
        this.log.debug("Request: {}", (Object)request);
        if (this.log.isTraceEnabled()) {
            if (request.getHeaders().isEmpty()) {
                this.log.trace("No request headers");
            } else {
                this.log.trace("Request headers:");
                Iterator iterator = request.getHeaders().iterator();
                while (iterator.hasNext()) {
                    Map.Entry header = (Map.Entry)iterator.next();
                    this.log.trace("  {}: {}", header.getKey(), header.getValue());
                }
            }
            if (request.getAttributes().isEmpty()) {
                this.log.trace("No request attributes");
            } else {
                this.log.trace("Request attributes:");
                for (Map.Entry entry : request.getAttributes()) {
                    this.log.trace("  {}={}", entry.getKey(), entry.getValue());
                }
            }
        }
    }

    private void logResponse(Response response) {
        this.log.debug("Response: {}", (Object)response);
        if (this.log.isTraceEnabled()) {
            if (response.getHeaders().isEmpty()) {
                this.log.trace("No response headers");
            } else {
                this.log.trace("Response headers:");
                Iterator iterator = response.getHeaders().iterator();
                while (iterator.hasNext()) {
                    Map.Entry header = (Map.Entry)iterator.next();
                    this.log.trace("  {}: {}", header.getKey(), header.getValue());
                }
            }
            if (response.getAttributes().isEmpty()) {
                this.log.trace("No response attributes");
            } else {
                this.log.trace("Response attributes:");
                for (Map.Entry entry : response.getAttributes()) {
                    this.log.trace("  {}={}", entry.getKey(), entry.getValue());
                }
            }
        }
    }

    private Route findRoute(Context context) {
        for (Route route : this.routes) {
            if (!route.getMatcher().matches(context)) continue;
            return route;
        }
        return this.defaultRoute;
    }

    public static class Builder {
        private List<Route> routes = Lists.newArrayList();
        private DefaultRoute defaultRoute;

        public Builder route(Route route) {
            Preconditions.checkNotNull((Object)route);
            this.routes.add(route);
            return this;
        }

        public Builder defaultHandlers(Handler ... handlers) {
            Preconditions.checkState((this.defaultRoute == null ? 1 : 0) != 0, (Object)"Default handlers already configured");
            this.defaultRoute = new DefaultRoute(Arrays.asList(handlers));
            return this;
        }

        public Router create() {
            return new Router(this.routes, this.defaultRoute);
        }
    }
}

