/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.view;

import com.google.common.base.Preconditions;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import org.apache.http.client.utils.URIBuilder;
import org.sonatype.nexus.repository.view.Context;
import org.sonatype.nexus.repository.view.Parameters;

public final class ViewUtils {
    private ViewUtils() {
    }

    public static String buildUrlWithParameters(String url, Parameters parameters) {
        Preconditions.checkNotNull((Object)url);
        Preconditions.checkNotNull((Object)((Object)parameters));
        try {
            URIBuilder builder = new URIBuilder(url);
            for (Map.Entry parameter : parameters.entries()) {
                builder.addParameter((String)parameter.getKey(), (String)parameter.getValue());
            }
            URI uri = builder.build();
            return uri.toString();
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Unable to build url with base url " + url + " and parameters " + (Object)((Object)parameters), e);
        }
    }

    public static void copyLocalContextAttributes(Context existingContext, Context newContext) {
        if (existingContext != null) {
            existingContext.getAttributes().keys().stream().filter(key -> !key.startsWith("local.attribute.")).forEach(key -> {
                Object object = newContext.getAttributes().set(key, existingContext.getAttributes().get(key));
            });
        }
    }
}

