/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.view.handlers;

import com.google.common.base.Predicate;
import javax.annotation.Nonnull;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.repository.http.HttpConditions;
import org.sonatype.nexus.repository.view.Context;
import org.sonatype.nexus.repository.view.Handler;
import org.sonatype.nexus.repository.view.Request;
import org.sonatype.nexus.repository.view.Response;
import org.sonatype.nexus.repository.view.Status;
import org.sonatype.nexus.repository.view.ViewFacet;

public class ConditionalRequestHandler
extends ComponentSupport
implements Handler {
    @Override
    @Nonnull
    public Response handle(@Nonnull Context context) throws Exception {
        Predicate<Response> requestPredicate = HttpConditions.requestPredicate(context.getRequest());
        if (requestPredicate != null) {
            HttpConditions.makeUnconditional(context.getRequest());
            try {
                Response response = this.handleConditional(context, requestPredicate);
                return response;
            }
            finally {
                HttpConditions.makeConditional(context.getRequest());
            }
        }
        return context.proceed();
    }

    @Nonnull
    private Response handleConditional(@Nonnull Context context, @Nonnull Predicate<Response> requestPredicate) throws Exception {
        String action = context.getRequest().getAction();
        this.log.debug("Conditional request: {} {}: {}", new Object[]{action, context.getRequest().getPath(), requestPredicate});
        switch (action) {
            case "GET": 
            case "HEAD": {
                Response response = context.proceed();
                if (response.getStatus().isSuccessful() && !requestPredicate.apply((Object)response)) {
                    Response.Builder responseBuilder = new Response.Builder().status(Status.success(304));
                    if (response.getHeaders().contains("ETag")) {
                        responseBuilder.header("ETag", response.getHeaders().get("ETag"));
                    }
                    return responseBuilder.build();
                }
                return response;
            }
            case "PUT": 
            case "POST": 
            case "DELETE": {
                Request getRequest = new Request.Builder().copy(context.getRequest()).action("GET").build();
                Response response = context.getRepository().facet(ViewFacet.class).dispatch(getRequest);
                if (response.getStatus().isSuccessful() && !requestPredicate.apply((Object)response)) {
                    return new Response.Builder().copy(response).status(Status.failure(412)).payload(null).build();
                }
                return context.proceed();
            }
        }
        return context.proceed();
    }
}

