/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.view.handlers;

import java.util.Date;
import javax.annotation.Nonnull;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.http.client.utils.DateUtils;
import org.joda.time.DateTime;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.repository.view.Content;
import org.sonatype.nexus.repository.view.Context;
import org.sonatype.nexus.repository.view.Handler;
import org.sonatype.nexus.repository.view.Payload;
import org.sonatype.nexus.repository.view.Response;

@Singleton
@Named
public class ContentHeadersHandler
extends ComponentSupport
implements Handler {
    @Override
    @Nonnull
    public Response handle(@Nonnull Context context) throws Exception {
        Response response = context.proceed();
        Payload payload = response.getPayload();
        if (response.getStatus().isSuccessful() && payload instanceof Content) {
            String etag;
            Content content = (Content)payload;
            DateTime lastModified = (DateTime)content.getAttributes().get("lastModified", DateTime.class);
            if (lastModified != null) {
                response.getHeaders().set("Last-Modified", new String[]{DateUtils.formatDate((Date)lastModified.toDate())});
            }
            if ((etag = (String)content.getAttributes().get("etag", String.class)) != null) {
                response.getHeaders().set("ETag", new String[]{"\"" + etag + "\""});
            }
        }
        return response;
    }
}

