/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.view.handlers;

import com.orientechnologies.common.concur.lock.OModificationOperationProhibitedException;
import com.orientechnologies.orient.server.distributed.ODistributedException;
import javax.annotation.Nonnull;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.repository.IllegalOperationException;
import org.sonatype.nexus.repository.InvalidContentException;
import org.sonatype.nexus.repository.http.HttpResponses;
import org.sonatype.nexus.repository.view.Context;
import org.sonatype.nexus.repository.view.Handler;
import org.sonatype.nexus.repository.view.Response;

public class ExceptionHandler
extends ComponentSupport
implements Handler {
    @Override
    @Nonnull
    public Response handle(@Nonnull Context context) throws Exception {
        try {
            return context.proceed();
        }
        catch (IllegalOperationException e) {
            this.log.warn("Illegal operation: {} {}: {}", new Object[]{context.getRequest().getAction(), context.getRequest().getPath(), e.toString()});
            return HttpResponses.badRequest(e.getMessage());
        }
        catch (InvalidContentException e) {
            this.log.warn("Invalid content: {} {}: {}", new Object[]{context.getRequest().getAction(), context.getRequest().getPath(), e.toString()});
            if ("PUT".equals(context.getRequest().getAction())) {
                return HttpResponses.badRequest(e.getMessage());
            }
            return HttpResponses.notFound(e.getMessage());
        }
        catch (OModificationOperationProhibitedException e) {
            this.log.warn("Nexus Repository Manager is in read-only mode: {} {}: {}", new Object[]{context.getRequest().getAction(), context.getRequest().getPath(), e.toString()});
            return HttpResponses.serviceUnavailable("Nexus Repository Manager is in read-only mode");
        }
        catch (ODistributedException e) {
            if ("OWriteOperationNotPermittedException".equals(((Object)((Object)e)).getClass().getSimpleName())) {
                this.log.warn("Nexus Repository Manager is in read-only mode: {} {}: {}", new Object[]{context.getRequest().getAction(), context.getRequest().getPath(), e.toString()});
                return HttpResponses.serviceUnavailable("Nexus Repository Manager is in read-only mode");
            }
            throw e;
        }
    }
}

