/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.view.handlers;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.util.List;
import java.util.ListIterator;
import javax.annotation.Nonnull;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.repository.view.Context;
import org.sonatype.nexus.repository.view.Handler;
import org.sonatype.nexus.repository.view.Response;
import org.sonatype.nexus.repository.view.handlers.ContributedHandler;

@Named
@Singleton
public class HandlerContributor
implements Handler {
    private final List<ContributedHandler> contributedHandlers;
    @VisibleForTesting
    static final String EXTENDED_MARKER = "local.attribute." + HandlerContributor.class.getName() + ".extended";

    @Inject
    public HandlerContributor(List<ContributedHandler> contributedHandlers) {
        this.contributedHandlers = (List)Preconditions.checkNotNull(contributedHandlers);
    }

    @Override
    @Nonnull
    public Response handle(@Nonnull Context context) throws Exception {
        if (!this.isMarkedExtended(context)) {
            ListIterator<ContributedHandler> handlerIterator = this.contributedHandlers.listIterator(this.contributedHandlers.size());
            while (handlerIterator.hasPrevious()) {
                context.insertHandler(handlerIterator.previous());
            }
            this.markExtended(context);
        }
        return context.proceed();
    }

    private boolean isMarkedExtended(Context context) {
        return context.getAttributes().contains(EXTENDED_MARKER);
    }

    private void markExtended(Context context) {
        context.getAttributes().set(EXTENDED_MARKER, (Object)Boolean.TRUE);
    }
}

