/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.view.handlers;

import javax.annotation.Nonnull;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.repository.http.HttpResponses;
import org.sonatype.nexus.repository.view.Context;
import org.sonatype.nexus.repository.view.Handler;
import org.sonatype.nexus.repository.view.Request;
import org.sonatype.nexus.repository.view.Response;
import org.sonatype.nexus.repository.view.ViewFacet;

@Named
@Singleton
public class IndexHtmlForwardHandler
extends ComponentSupport
implements Handler {
    private static final String[] INDEX_FILES = new String[]{"index.html", "index.htm"};

    @Override
    @Nonnull
    public Response handle(@Nonnull Context context) throws Exception {
        String path = context.getRequest().getPath();
        if (!path.endsWith("/")) {
            path = String.valueOf(path) + "/";
        }
        String[] stringArray = INDEX_FILES;
        int n = INDEX_FILES.length;
        int n2 = 0;
        while (n2 < n) {
            String file = stringArray[n2];
            Response response = this.forward(context, String.valueOf(path) + file);
            if (response.getStatus().isSuccessful() || response.getStatus().getCode() != 404) {
                return response;
            }
            ++n2;
        }
        return HttpResponses.notFound(context.getRequest().getPath());
    }

    private Response forward(Context context, String path) throws Exception {
        this.log.trace("Forwarding request to path: {}", (Object)path);
        Request request = new Request.Builder().copy(context.getRequest()).path(path).build();
        return context.getRepository().facet(ViewFacet.class).dispatch(request);
    }
}

