/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.view.handlers;

import com.google.common.annotations.VisibleForTesting;
import com.orientechnologies.orient.core.exception.ORecordNotFoundException;
import java.io.IOException;
import javax.annotation.Nullable;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.common.collect.AttributesMap;
import org.sonatype.nexus.common.entity.Entity;
import org.sonatype.nexus.common.entity.EntityHelper;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.storage.Asset;
import org.sonatype.nexus.repository.storage.StorageFacet;
import org.sonatype.nexus.repository.storage.StorageTx;
import org.sonatype.nexus.repository.transaction.TransactionalTouchMetadata;
import org.sonatype.nexus.repository.view.Content;
import org.sonatype.nexus.repository.view.Context;
import org.sonatype.nexus.repository.view.Handler;
import org.sonatype.nexus.repository.view.Response;
import org.sonatype.nexus.transaction.UnitOfWork;

@Named
@Singleton
public class LastDownloadedHandler
extends ComponentSupport
implements Handler {
    @Override
    public Response handle(Context context) throws Exception {
        Response response = context.proceed();
        try {
            if (this.isSuccessfulRequestWithContent(context, response)) {
                Repository repository = context.getRepository();
                StorageFacet storageFacet = repository.facet(StorageFacet.class);
                Content content = (Content)response.getPayload();
                AttributesMap attributes = content.getAttributes();
                this.maybeUpdateLastDownloaded(storageFacet, attributes);
            }
        }
        catch (Exception e) {
            this.log.error("Failed to update last downloaded time for request {}", (Object)context.getRequest().getPath(), (Object)e);
        }
        return response;
    }

    protected void maybeUpdateLastDownloaded(StorageFacet storageFacet, AttributesMap attributes) throws IOException {
        Asset asset = (Asset)attributes.get(Asset.class);
        this.maybeUpdateLastDownloaded(storageFacet, asset);
    }

    private boolean isSuccessfulRequestWithContent(Context context, Response response) {
        return this.isGetOrHeadRequest(context) && this.isSuccessfulOrNotModified(response) && response.getPayload() != null && response.getPayload() instanceof Content;
    }

    private boolean isSuccessfulOrNotModified(Response response) {
        return response.getStatus().isSuccessful() || response.getStatus().getCode() == 304;
    }

    private boolean isGetOrHeadRequest(Context context) {
        String action = context.getRequest().getAction();
        return "GET".equals(action) || "HEAD".equals(action);
    }

    protected void maybeUpdateLastDownloaded(StorageFacet storageFacet, Asset asset) throws IOException {
        if (asset != null && asset.markAsDownloaded()) {
            TransactionalTouchMetadata.operation.withDb(storageFacet.txSupplier()).throwing(IOException.class).swallow(new Class[]{ORecordNotFoundException.class}).call(() -> {
                StorageTx tx = (StorageTx)UnitOfWork.currentTx();
                Asset updatedAsset = tx.findAsset(EntityHelper.id((Entity)asset));
                this.updateLastDownloadedTime(tx, updatedAsset);
                return null;
            });
        }
    }

    @VisibleForTesting
    void updateLastDownloadedTime(StorageTx tx, @Nullable Asset updatedAsset) {
        if (updatedAsset != null && updatedAsset.markAsDownloaded()) {
            tx.saveAsset(updatedAsset);
        }
    }
}

