/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.view.matchers;

import com.google.common.base.Preconditions;
import java.util.Arrays;
import java.util.List;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.repository.view.Context;
import org.sonatype.nexus.repository.view.Matcher;

public class ActionMatcher
extends ComponentSupport
implements Matcher {
    private final List<String> allowedActions;

    public ActionMatcher(String ... allowedActions) {
        Preconditions.checkNotNull((Object)allowedActions);
        Preconditions.checkArgument((allowedActions.length > 0 ? 1 : 0) != 0, (Object)"at least one allowed action must be specified");
        this.allowedActions = Arrays.asList(allowedActions);
    }

    @Override
    public boolean matches(Context context) {
        String action = context.getRequest().getAction();
        return this.allowedActions.contains(action);
    }
}

