/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.view.matchers;

import com.google.common.base.Preconditions;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.repository.view.Context;
import org.sonatype.nexus.repository.view.Matcher;

public class LiteralMatcher
extends ComponentSupport
implements Matcher {
    private final String literal;
    private final boolean ignoreCase;

    public LiteralMatcher(String literal, boolean ignoreCase) {
        this.literal = (String)Preconditions.checkNotNull((Object)literal);
        this.ignoreCase = ignoreCase;
    }

    public LiteralMatcher(String literal) {
        this(literal, true);
    }

    @Override
    public boolean matches(Context context) {
        Preconditions.checkNotNull((Object)context);
        String path = context.getRequest().getPath();
        this.log.debug("Matching: {}={} ignore-case: {}", new Object[]{path, this.literal, this.ignoreCase});
        if (this.ignoreCase) {
            return path.equalsIgnoreCase(this.literal);
        }
        return path.equals(this.literal);
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + "{" + "literal='" + this.literal + '\'' + ", ignoreCase=" + this.ignoreCase + '}';
    }
}

