/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.view.matchers;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.common.text.Strings2;
import org.sonatype.nexus.repository.view.Context;
import org.sonatype.nexus.repository.view.Matcher;

public class PrefixMatcher
extends ComponentSupport
implements Matcher {
    private final String prefix;
    private final boolean ignoreCase;

    @VisibleForTesting
    public PrefixMatcher(String prefix, boolean ignoreCase) {
        this.prefix = (String)Preconditions.checkNotNull((Object)prefix);
        this.ignoreCase = ignoreCase;
    }

    public PrefixMatcher(String prefix) {
        this(prefix, false);
    }

    public PrefixMatcher ignoreCase(boolean ignoreCase) {
        return new PrefixMatcher(this.prefix, ignoreCase);
    }

    @Override
    public boolean matches(Context context) {
        Preconditions.checkNotNull((Object)context);
        String path = context.getRequest().getPath();
        this.log.debug("Matching: {} starts-with={} ignore-case: {}", new Object[]{path, this.prefix, this.ignoreCase});
        if (this.ignoreCase) {
            return Strings2.lower((String)path).startsWith(Strings2.lower((String)this.prefix));
        }
        return path.startsWith(this.prefix);
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + "{" + "prefix='" + this.prefix + '\'' + ", ignoreCase=" + this.ignoreCase + '}';
    }
}

