/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.view.matchers.logic;

import com.google.common.base.Preconditions;
import java.util.Arrays;
import org.sonatype.nexus.repository.view.Matcher;
import org.sonatype.nexus.repository.view.matchers.logic.AndMatcher;
import org.sonatype.nexus.repository.view.matchers.logic.NotMatcher;
import org.sonatype.nexus.repository.view.matchers.logic.OrMatcher;

public class LogicMatchers {
    private LogicMatchers() {
    }

    public static Matcher and(Matcher ... matchers) {
        Preconditions.checkNotNull((Object)matchers);
        Preconditions.checkArgument((matchers.length > 1 ? 1 : 0) != 0, (Object)"AND requires 2 or more matchers");
        return new AndMatcher(Arrays.asList(matchers));
    }

    public static Matcher or(Matcher ... matchers) {
        Preconditions.checkNotNull((Object)matchers);
        Preconditions.checkArgument((matchers.length > 1 ? 1 : 0) != 0, (Object)"OR requires 2 or more matchers");
        return new OrMatcher(Arrays.asList(matchers));
    }

    public static Matcher not(Matcher matcher) {
        return new NotMatcher(matcher);
    }
}

