/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.view.matchers.token;

import com.google.common.base.Preconditions;
import java.util.Map;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.repository.view.Context;
import org.sonatype.nexus.repository.view.Matcher;
import org.sonatype.nexus.repository.view.matchers.token.TokenParser;

public class TokenMatcher
extends ComponentSupport
implements Matcher {
    private final TokenParser parser;
    private final String pattern;

    public TokenMatcher(String pattern) {
        this.pattern = (String)Preconditions.checkNotNull((Object)pattern);
        this.parser = new TokenParser(pattern);
    }

    @Override
    public boolean matches(Context context) {
        Preconditions.checkNotNull((Object)context);
        String path = context.getRequest().getPath();
        this.log.debug("Matching: {}~={}", (Object)path, (Object)this.parser);
        final Map<String, String> tokens = this.parser.parse(path);
        if (tokens == null) {
            return false;
        }
        context.getAttributes().set(State.class, (Object)new State(){

            @Override
            public String pattern() {
                return TokenMatcher.this.pattern;
            }

            @Override
            public Map<String, String> getTokens() {
                return tokens;
            }
        });
        return true;
    }

    public static interface State {
        public String pattern();

        public Map<String, String> getTokens();
    }
}

