/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.view.matchers.token;

import com.google.common.base.Objects;
import org.sonatype.nexus.repository.view.matchers.token.Token;

public class VariableToken
extends Token {
    private final String name;

    public VariableToken(String name, String regexp) {
        super(regexp);
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    @Override
    public String toRegexp() {
        return "(" + this.value + ")";
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VariableToken)) {
            return false;
        }
        VariableToken other = (VariableToken)obj;
        return Objects.equal((Object)this.getName(), (Object)other.getName()) && super.equals(obj);
    }

    @Override
    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.name, this.value});
    }

    public String toString() {
        return String.format("var(%s,%s)", this.name, this.value);
    }
}

