/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.view.payloads;

import com.google.common.base.Preconditions;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.annotation.Nullable;
import org.sonatype.nexus.repository.view.Payload;

public class BytesPayload
implements Payload {
    private final byte[] content;
    private final String contentType;

    public BytesPayload(byte[] content, @Nullable String contentType) {
        this.content = (byte[])Preconditions.checkNotNull((Object)content);
        this.contentType = contentType;
    }

    @Override
    public InputStream openInputStream() throws IOException {
        return new ByteArrayInputStream(this.content);
    }

    @Override
    public long getSize() {
        return this.content.length;
    }

    @Override
    @Nullable
    public String getContentType() {
        return this.contentType;
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + "{" + "size=" + this.getSize() + ", contentType='" + this.contentType + '\'' + '}';
    }
}

