/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.view.payloads;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.InputStream;
import javax.annotation.Nullable;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.util.EntityUtils;
import org.sonatype.nexus.repository.view.Payload;

public class HttpEntityPayload
implements Payload {
    private final HttpResponse response;
    private final HttpEntity entity;

    public HttpEntityPayload(HttpResponse response, HttpEntity entity) {
        this.response = (HttpResponse)Preconditions.checkNotNull((Object)response);
        this.entity = (HttpEntity)Preconditions.checkNotNull((Object)entity);
    }

    @Override
    public InputStream openInputStream() throws IOException {
        return this.entity.getContent();
    }

    @Override
    public long getSize() {
        return this.entity.getContentLength();
    }

    @Override
    @Nullable
    public String getContentType() {
        Header header = this.entity.getContentType();
        if (header != null) {
            return header.getValue();
        }
        return null;
    }

    @Override
    public void close() throws IOException {
        EntityUtils.consume((HttpEntity)this.entity);
    }
}

