/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.view.payloads;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.InputStream;
import javax.annotation.Nullable;
import org.sonatype.nexus.repository.storage.TempBlob;
import org.sonatype.nexus.repository.view.PartPayload;

public class TempBlobPartPayload
implements PartPayload {
    private final PartPayload payload;
    private final TempBlob tempBlob;

    public TempBlobPartPayload(PartPayload payload, TempBlob tempBlob) throws IOException {
        this.payload = (PartPayload)Preconditions.checkNotNull((Object)payload);
        this.tempBlob = (TempBlob)Preconditions.checkNotNull((Object)tempBlob);
    }

    @Override
    @Nullable
    public String getName() {
        return this.payload.getName();
    }

    @Override
    public String getFieldName() {
        return this.payload.getFieldName();
    }

    @Override
    public boolean isFormField() {
        return this.payload.isFormField();
    }

    @Override
    public InputStream openInputStream() throws IOException {
        return this.tempBlob.get();
    }

    @Override
    public long getSize() {
        return -1L;
    }

    @Override
    @Nullable
    public String getContentType() {
        return this.payload.getContentType();
    }

    public TempBlob getTempBlob() {
        return this.tempBlob;
    }

    @Override
    public void close() throws IOException {
        this.tempBlob.close();
    }
}

