/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.blobstore.file;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Map;
import java.util.Properties;
import org.sonatype.nexus.blobstore.BlobAttributesSupport;
import org.sonatype.nexus.blobstore.api.BlobMetrics;
import org.sonatype.nexus.common.property.PropertiesFile;

public class FileBlobAttributes
extends BlobAttributesSupport<PropertiesFile> {
    public FileBlobAttributes(Path path) {
        super((Properties)new PropertiesFile(path.toFile()), null, null);
    }

    public FileBlobAttributes(Path path, Map<String, String> headers, BlobMetrics metrics) {
        super((Properties)new PropertiesFile(path.toFile()), (Map)Preconditions.checkNotNull(headers), (BlobMetrics)Preconditions.checkNotNull((Object)metrics));
    }

    public Path getPath() {
        return ((PropertiesFile)this.propertiesFile).getFile().toPath();
    }

    public boolean load() throws IOException {
        if (!Files.exists(this.getPath(), new LinkOption[0])) {
            return false;
        }
        ((PropertiesFile)this.propertiesFile).load();
        this.readFrom(this.propertiesFile);
        return true;
    }

    public void store() throws IOException {
        this.writeTo(this.propertiesFile);
        ((PropertiesFile)this.propertiesFile).store();
    }
}

