/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.blobstore.file.internal;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileStore;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import javax.inject.Inject;
import javax.inject.Named;
import org.sonatype.nexus.blobstore.AccumulatingBlobStoreMetrics;
import org.sonatype.nexus.blobstore.BlobStoreMetricsStoreSupport;
import org.sonatype.nexus.blobstore.PeriodicJobService;
import org.sonatype.nexus.blobstore.file.internal.FileOperations;
import org.sonatype.nexus.blobstore.quota.BlobStoreQuotaService;
import org.sonatype.nexus.common.node.NodeAccess;
import org.sonatype.nexus.common.property.PropertiesFile;

@Named
public class FileBlobStoreMetricsStore
extends BlobStoreMetricsStoreSupport<PropertiesFile> {
    private Path storageDirectory;
    private final FileOperations fileOperations;

    @Inject
    public FileBlobStoreMetricsStore(PeriodicJobService jobService, NodeAccess nodeAccess, BlobStoreQuotaService quotaService, @Named(value="${nexus.blobstore.quota.warnIntervalSeconds:-60}") int quotaCheckInterval, FileOperations fileOperations) {
        super(nodeAccess, jobService, quotaService, quotaCheckInterval);
        this.fileOperations = (FileOperations)Preconditions.checkNotNull((Object)fileOperations);
    }

    protected PropertiesFile getProperties() {
        Path metricsDataFile = this.storageDirectory.resolve(String.valueOf(this.nodeAccess.getId()) + "-" + "metrics.properties");
        return new PropertiesFile(metricsDataFile.toFile());
    }

    protected AccumulatingBlobStoreMetrics getAccumulatingBlobStoreMetrics() {
        try {
            FileStore fileStore = Files.getFileStore(this.storageDirectory);
            ImmutableMap availableSpace = ImmutableMap.of((Object)("fileStore:" + fileStore.name()), (Object)fileStore.getUsableSpace());
            return new AccumulatingBlobStoreMetrics(0L, 0L, (Map)availableSpace, false);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public Stream<PropertiesFile> backingFiles() {
        if (this.storageDirectory == null) {
            return Stream.empty();
        }
        return Optional.ofNullable(this.storageDirectory.toFile().listFiles((dir, name) -> name.endsWith("metrics.properties"))).map(files -> Arrays.stream(files).filter(Objects::nonNull).map(PropertiesFile::new)).orElse(Stream.empty());
    }

    public void setStorageDir(Path storageDirectory) {
        Preconditions.checkNotNull((Object)storageDirectory);
        Preconditions.checkArgument((boolean)Files.isDirectory(storageDirectory, new LinkOption[0]));
        this.storageDirectory = storageDirectory;
    }

    public void remove() {
        this.backingFiles().map(PropertiesFile::getFile).map(File::toPath).forEach(this.fileOperations::deleteQuietly);
    }
}

