/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.blobstore.file.internal;

import com.google.common.base.Preconditions;
import com.google.common.io.ByteStreams;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.AtomicMoveNotSupportedException;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryNotEmptyException;
import java.nio.file.FileSystemException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import javax.inject.Named;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.blobstore.MetricsInputStream;
import org.sonatype.nexus.blobstore.StreamMetrics;
import org.sonatype.nexus.blobstore.file.internal.FileOperations;
import org.sonatype.nexus.common.io.DirectoryHelper;

@Named
public class SimpleFileOperations
extends ComponentSupport
implements FileOperations {
    @Override
    public StreamMetrics create(Path path, InputStream data) throws IOException {
        Preconditions.checkNotNull((Object)path);
        Preconditions.checkNotNull((Object)data);
        Path dir = path.getParent();
        Preconditions.checkNotNull((Object)dir, (String)"Null parent for path: %s", (Object)path);
        DirectoryHelper.mkdir((Path)dir);
        MetricsInputStream input = new MetricsInputStream(data);
        try {
            Throwable throwable = null;
            Object var6_7 = null;
            try (OutputStream output = Files.newOutputStream(path, StandardOpenOption.CREATE_NEW);){
                ByteStreams.copy((InputStream)input, (OutputStream)output);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        finally {
            data.close();
        }
        return input.getMetrics();
    }

    @Override
    public void hardLink(Path source, Path newLink) throws IOException {
        DirectoryHelper.mkdir((Path)newLink.getParent());
        try {
            Files.createLink(newLink, source);
        }
        catch (UnsupportedOperationException e) {
            throw new IOException(e);
        }
        this.log.debug("Hard link created from {} to {}", (Object)newLink, (Object)source);
    }

    @Override
    public void copy(Path source, Path target) throws IOException {
        Preconditions.checkNotNull((Object)source);
        Preconditions.checkNotNull((Object)target);
        DirectoryHelper.mkdir((Path)target.getParent());
        Files.copy(source, target, new CopyOption[0]);
    }

    @Override
    public void move(Path source, Path target) throws IOException {
        Preconditions.checkNotNull((Object)source);
        Preconditions.checkNotNull((Object)target);
        DirectoryHelper.mkdir((Path)target.getParent());
        Files.move(source, target, new CopyOption[0]);
    }

    @Override
    public void moveAtomic(Path source, Path target) throws IOException {
        Preconditions.checkNotNull((Object)source);
        Preconditions.checkNotNull((Object)target);
        DirectoryHelper.mkdir((Path)target.getParent());
        try {
            Files.move(source, target, StandardCopyOption.ATOMIC_MOVE);
        }
        catch (UnsupportedOperationException e) {
            throw new AtomicMoveNotSupportedException(source.toString(), target.toString(), e.getMessage());
        }
    }

    @Override
    public void overwrite(Path source, Path target) throws IOException {
        Preconditions.checkNotNull((Object)source);
        Preconditions.checkNotNull((Object)target);
        DirectoryHelper.mkdir((Path)target.getParent());
        Files.move(source, target, StandardCopyOption.REPLACE_EXISTING);
    }

    @Override
    public void overwriteAtomic(Path source, Path target) throws IOException {
        Preconditions.checkNotNull((Object)source);
        Preconditions.checkNotNull((Object)target);
        DirectoryHelper.mkdir((Path)target.getParent());
        try {
            Files.move(source, target, StandardCopyOption.ATOMIC_MOVE, StandardCopyOption.REPLACE_EXISTING);
        }
        catch (UnsupportedOperationException e) {
            throw new AtomicMoveNotSupportedException(source.toString(), target.toString(), e.getMessage());
        }
    }

    @Override
    public void copyIfLocked(Path source, Path target, FileOperations.Mover mover) throws IOException {
        Preconditions.checkNotNull((Object)source);
        Preconditions.checkNotNull((Object)target);
        try {
            mover.accept(source, target);
        }
        catch (AtomicMoveNotSupportedException atomicMoveNotSupported) {
            throw atomicMoveNotSupported;
        }
        catch (FileSystemException fileSystemException) {
            this.log.warn("Using copy to move {} to {}", (Object)source, (Object)target);
            this.copy(source, target);
            try {
                this.delete(source);
            }
            catch (IOException deleteException) {
                this.log.error("Unable to delete {} after move: {}", (Object)source, (Object)deleteException.getMessage());
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public StreamMetrics computeMetrics(Path file) throws IOException {
        Throwable throwable = null;
        Object var3_4 = null;
        try {
            InputStream is = Files.newInputStream(file, new OpenOption[0]);
            try {
                StreamMetrics streamMetrics;
                block14: {
                    MetricsInputStream mis = new MetricsInputStream(is);
                    try {
                        ByteStreams.copy((InputStream)mis, (OutputStream)ByteStreams.nullOutputStream());
                        streamMetrics = mis.getMetrics();
                        return streamMetrics;
                    }
                    finally {
                        if (mis == null) break block14;
                        mis.close();
                    }
                }
                if (is != null) {
                    is.close();
                }
                return streamMetrics;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                if (is == null) throw throwable;
                is.close();
                throw throwable;
            }
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
                throw throwable;
            }
            if (throwable == throwable3) throw throwable;
            throwable.addSuppressed(throwable3);
            throw throwable;
        }
    }

    @Override
    public boolean exists(Path path) {
        Preconditions.checkNotNull((Object)path);
        return Files.exists(path, new LinkOption[0]);
    }

    @Override
    public InputStream openInputStream(Path path) throws IOException {
        Preconditions.checkNotNull((Object)path);
        return Files.newInputStream(path, StandardOpenOption.READ);
    }

    @Override
    public boolean delete(Path path) throws IOException {
        Preconditions.checkNotNull((Object)path);
        Preconditions.checkArgument((!Files.isDirectory(path, new LinkOption[0]) ? 1 : 0) != 0);
        boolean deleted = Files.deleteIfExists(path);
        if (!deleted && this.exists(path)) {
            throw new IOException("File was not successfully deleted: " + path);
        }
        return deleted;
    }

    @Override
    public boolean deleteQuietly(Path path) {
        try {
            return this.delete(path);
        }
        catch (Exception e) {
            this.log.warn("Unable to delete path {}", (Object)path, (Object)e);
            return false;
        }
    }

    @Override
    public void deleteDirectory(Path directory) throws IOException {
        DirectoryHelper.emptyIfExists((Path)directory);
        Files.deleteIfExists(directory);
    }

    @Override
    public boolean deleteEmptyDirectory(Path directory) throws IOException {
        try {
            Files.deleteIfExists(directory);
            return true;
        }
        catch (DirectoryNotEmptyException e) {
            this.log.debug("Cannot remove non-empty directory {}", (Object)directory, (Object)e);
            return false;
        }
    }
}

