/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.siesta;

import com.google.common.base.Preconditions;
import java.util.List;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.GenericEntity;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Request;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.Variant;
import org.sonatype.nexus.rest.ExceptionMapperSupport;
import org.sonatype.nexus.rest.MediaTypes;
import org.sonatype.nexus.rest.ValidationErrorXO;

public abstract class ValidationExceptionMapperSupport<E extends Throwable>
extends ExceptionMapperSupport<E> {
    private final List<Variant> variants = Variant.mediaTypes((MediaType[])new MediaType[]{MediaTypes.VND_VALIDATION_ERRORS_V1_JSON_TYPE, MediaTypes.VND_VALIDATION_ERRORS_V1_XML_TYPE}).add().build();
    private Request request;

    protected Response convert(E exception, String id) {
        Variant variant;
        Response.ResponseBuilder builder = Response.status((Response.Status)this.getStatus(exception));
        List<ValidationErrorXO> errors = this.getValidationErrors(exception);
        if (errors != null && !errors.isEmpty() && (variant = this.getRequest().selectVariant(this.variants)) != null) {
            builder.type(variant.getMediaType()).entity((Object)new GenericEntity<List<ValidationErrorXO>>(errors){

                public String toString() {
                    return ((List)this.getEntity()).toString();
                }
            });
        }
        return builder.build();
    }

    protected Response.Status getStatus(E exception) {
        return Response.Status.BAD_REQUEST;
    }

    protected abstract List<ValidationErrorXO> getValidationErrors(E var1);

    @Context
    public void setRequest(Request request) {
        this.request = (Request)Preconditions.checkNotNull((Object)request);
    }

    protected Request getRequest() {
        Preconditions.checkState((this.request != null ? 1 : 0) != 0);
        return this.request;
    }
}

