/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.siesta.internal;

import com.google.common.base.Preconditions;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.core.Response;
import org.apache.shiro.authz.AuthorizationException;
import org.sonatype.nexus.rest.ExceptionMapperSupport;

@Named
@Singleton
public class AuthorizationExceptionMapper
extends ExceptionMapperSupport<AuthorizationException> {
    private static final String AUTH_SCHEME_KEY = "auth.scheme";
    private static final String AUTH_REALM_KEY = "auth.realm";
    private static final String ANONYMOUS_LOGIN = "nexus.anonymous";
    private static final String AUTHENTICATE_HEADER = "WWW-Authenticate";
    private final Provider<HttpServletRequest> httpRequestProvider;

    @Inject
    public AuthorizationExceptionMapper(Provider<HttpServletRequest> httpRequestProvider) {
        this.httpRequestProvider = (Provider)Preconditions.checkNotNull(httpRequestProvider);
    }

    protected Response convert(AuthorizationException exception, String id) {
        HttpServletRequest httpRequest = (HttpServletRequest)this.httpRequestProvider.get();
        if (httpRequest.getAttribute(ANONYMOUS_LOGIN) != null) {
            String scheme = (String)httpRequest.getAttribute(AUTH_SCHEME_KEY);
            String realm = (String)httpRequest.getAttribute(AUTH_REALM_KEY);
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).header(AUTHENTICATE_HEADER, (Object)String.format("%s realm=\"%s\"", scheme, realm)).build();
        }
        return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
    }
}

