/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.siesta.internal;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.validation.ConstraintViolation;
import javax.validation.ConstraintViolationException;
import javax.validation.ElementKind;
import javax.validation.Path;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.Provider;
import org.sonatype.nexus.rest.ValidationErrorXO;
import org.sonatype.nexus.siesta.ValidationExceptionMapperSupport;

@Named
@Singleton
@Provider
public class ConstraintViolationExceptionMapper
extends ValidationExceptionMapperSupport<ConstraintViolationException> {
    @Override
    protected List<ValidationErrorXO> getValidationErrors(ConstraintViolationException exception) {
        return this.getValidationErrors(exception.getConstraintViolations());
    }

    @Override
    protected Response.Status getStatus(ConstraintViolationException exception) {
        return this.getResponseStatus(exception.getConstraintViolations());
    }

    @Override
    private List<ValidationErrorXO> getValidationErrors(Set<ConstraintViolation<?>> violations) {
        ArrayList<ValidationErrorXO> errors = new ArrayList<ValidationErrorXO>();
        for (ConstraintViolation<?> violation : violations) {
            errors.add(new ValidationErrorXO(this.getPath(violation), violation.getMessage()));
        }
        return errors;
    }

    private Response.Status getResponseStatus(Set<ConstraintViolation<?>> violations) {
        Iterator<ConstraintViolation<?>> iterator = violations.iterator();
        if (iterator.hasNext()) {
            return this.getResponseStatus(iterator.next());
        }
        return Response.Status.BAD_REQUEST;
    }

    private Response.Status getResponseStatus(ConstraintViolation<?> violation) {
        for (Path.Node node : violation.getPropertyPath()) {
            ElementKind kind = node.getKind();
            if (!ElementKind.RETURN_VALUE.equals((Object)kind)) continue;
            return Response.Status.INTERNAL_SERVER_ERROR;
        }
        return Response.Status.BAD_REQUEST;
    }

    private String getPath(ConstraintViolation violation) {
        String leafBeanName = violation.getLeafBean().getClass().getSimpleName();
        int proxySuffix = leafBeanName.indexOf("$$EnhancerByGuice");
        if (proxySuffix > 0) {
            leafBeanName = leafBeanName.substring(0, proxySuffix);
        }
        String propertyPath = violation.getPropertyPath().toString();
        return String.valueOf(leafBeanName) + (!"".equals(propertyPath) ? String.valueOf('.') + propertyPath : "");
    }
}

