/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.siesta.internal.resteasy;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.Provider;
import org.jboss.resteasy.api.validation.ConstraintType;
import org.jboss.resteasy.api.validation.ResteasyConstraintViolation;
import org.jboss.resteasy.api.validation.ResteasyViolationException;
import org.sonatype.nexus.rest.ValidationErrorXO;
import org.sonatype.nexus.siesta.ValidationExceptionMapperSupport;

@Named
@Singleton
@Provider
public class ResteasyViolationExceptionMapper
extends ValidationExceptionMapperSupport<ResteasyViolationException> {
    @Override
    protected List<ValidationErrorXO> getValidationErrors(ResteasyViolationException exception) {
        return this.getValidationErrors(exception.getViolations());
    }

    @Override
    protected Response.Status getStatus(ResteasyViolationException exception) {
        return this.getResponseStatus(exception.getViolations());
    }

    @Override
    private List<ValidationErrorXO> getValidationErrors(List<ResteasyConstraintViolation> violations) {
        ArrayList<ValidationErrorXO> errors = new ArrayList<ValidationErrorXO>();
        for (ResteasyConstraintViolation violation : violations) {
            errors.add(new ValidationErrorXO(this.getPath(violation), violation.getMessage()));
        }
        return errors;
    }

    private Response.Status getResponseStatus(List<ResteasyConstraintViolation> violations) {
        Iterator<ResteasyConstraintViolation> iterator = violations.iterator();
        if (iterator.hasNext()) {
            return this.getResponseStatus(iterator.next());
        }
        return Response.Status.BAD_REQUEST;
    }

    private Response.Status getResponseStatus(ResteasyConstraintViolation violation) {
        if (ConstraintType.Type.RETURN_VALUE.equals((Object)violation.getConstraintType())) {
            return Response.Status.INTERNAL_SERVER_ERROR;
        }
        return Response.Status.BAD_REQUEST;
    }

    private String getPath(ResteasyConstraintViolation violation) {
        String propertyPath = violation.getPath();
        return String.valueOf(violation.type()) + (!"".equals(propertyPath) ? String.valueOf(' ') + propertyPath : "");
    }
}

