/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.siesta.internal.resteasy;

import com.google.common.base.Preconditions;
import org.eclipse.sisu.BeanEntry;
import org.jboss.resteasy.spi.HttpRequest;
import org.jboss.resteasy.spi.HttpResponse;
import org.jboss.resteasy.spi.PropertyInjector;
import org.jboss.resteasy.spi.ResourceFactory;
import org.jboss.resteasy.spi.ResteasyProviderFactory;

public class SisuResourceFactory
implements ResourceFactory {
    private final BeanEntry<?, ?> entry;
    private PropertyInjector propertyInjector;

    public SisuResourceFactory(BeanEntry<?, ?> entry) {
        this.entry = (BeanEntry)Preconditions.checkNotNull(entry);
    }

    public Class<?> getScannableClass() {
        return this.entry.getImplementationClass();
    }

    public void registered(ResteasyProviderFactory factory) {
        Preconditions.checkNotNull((Object)factory);
        this.propertyInjector = factory.getInjectorFactory().createPropertyInjector(this.getScannableClass(), factory);
    }

    public Object createResource(HttpRequest request, HttpResponse response, ResteasyProviderFactory factory) {
        Object resource = this.entry.getValue();
        this.propertyInjector.inject(request, response, resource);
        return resource;
    }

    public void requestFinished(HttpRequest request, HttpResponse response, Object resource) {
    }

    public void unregistered() {
    }
}

