/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.siesta.internal.resteasy;

import com.google.common.base.Preconditions;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Collection;
import javax.ws.rs.container.DynamicFeature;
import javax.ws.rs.core.Feature;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.ContextResolver;
import javax.ws.rs.ext.ExceptionMapper;
import javax.ws.rs.ext.MessageBodyReader;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.ws.rs.ext.ParamConverterProvider;
import org.jboss.resteasy.core.MediaTypeMap;
import org.jboss.resteasy.spi.ResteasyProviderFactory;
import org.jboss.resteasy.spi.StringConverter;
import org.jboss.resteasy.spi.StringParameterUnmarshaller;
import org.jboss.resteasy.util.Types;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SisuResteasyProviderFactory
extends ResteasyProviderFactory {
    private static final Logger log = LoggerFactory.getLogger(SisuResteasyProviderFactory.class);
    private static final MessageBodyReader<?> DUMMY_READER = new MessageBodyReader<Object>(){

        public boolean isReadable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
            return false;
        }

        public Object readFrom(Class<Object> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, String> httpHeaders, InputStream entityStream) {
            return null;
        }
    };
    private static final MessageBodyWriter<?> DUMMY_WRITER = new MessageBodyWriter<Object>(){

        public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
            return false;
        }

        public void writeTo(Object t, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) {
        }

        public long getSize(Object t, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
            return 0L;
        }
    };

    public void removeRegistrations(Class<?> type) {
        Preconditions.checkNotNull(type);
        log.debug("Removing registrations for: {}", (Object)type.getName());
        this.classContracts.remove(type);
        SisuResteasyProviderFactory.removeInstancesOf(type, this.providerInstances);
        this.providerClasses.remove(type);
        if (ExceptionMapper.class.isAssignableFrom(type)) {
            SisuResteasyProviderFactory.removeInstancesOf(type, this.exceptionMappers.values());
        } else if (MessageBodyReader.class.isAssignableFrom(type)) {
            SisuResteasyProviderFactory.clearInstancesOf(type, this.clientMessageBodyReaders, DUMMY_READER);
            SisuResteasyProviderFactory.clearInstancesOf(type, this.serverMessageBodyReaders, DUMMY_READER);
        } else if (MessageBodyWriter.class.isAssignableFrom(type)) {
            SisuResteasyProviderFactory.clearInstancesOf(type, this.clientMessageBodyWriters, DUMMY_WRITER);
            SisuResteasyProviderFactory.clearInstancesOf(type, this.serverMessageBodyWriters, DUMMY_WRITER);
        } else if (ContextResolver.class.isAssignableFrom(type)) {
            Type[] args = Types.getActualTypeArgumentsOfAnInterface(type, ContextResolver.class);
            this.contextResolvers.remove(Types.getRawType((Type)args[0]));
        } else if (Feature.class.isAssignableFrom(type)) {
            SisuResteasyProviderFactory.removeInstancesOf(type, this.featureInstances);
            SisuResteasyProviderFactory.removeInstancesOf(type, this.enabledFeatures);
            this.featureClasses.remove(type);
        } else if (DynamicFeature.class.isAssignableFrom(type)) {
            SisuResteasyProviderFactory.removeInstancesOf(type, this.clientDynamicFeatures);
            SisuResteasyProviderFactory.removeInstancesOf(type, this.serverDynamicFeatures);
        } else if (ParamConverterProvider.class.isAssignableFrom(type)) {
            SisuResteasyProviderFactory.removeInstancesOf(type, this.paramConverterProviders);
        } else if (StringConverter.class.isAssignableFrom(type)) {
            SisuResteasyProviderFactory.removeInstancesOf(type, this.stringConverters.values());
        } else if (StringParameterUnmarshaller.class.isAssignableFrom(type)) {
            this.stringParameterUnmarshallers.values().remove(type);
        } else {
            log.warn("Unable to remove registrations for: {}", (Object)type.getName());
        }
    }

    private static void removeInstancesOf(Class<?> type, Collection<?> collection) {
        for (Object o : collection) {
            if (!type.isInstance(o)) continue;
            collection.remove(o);
        }
    }

    private static <T> void clearInstancesOf(Class type, MediaTypeMap<ResteasyProviderFactory.SortedKey<T>> mediaTypeMap, T placeholder) {
        for (ResteasyProviderFactory.SortedKey key : mediaTypeMap.getPossible(MediaType.WILDCARD_TYPE)) {
            if (!type.isInstance(key.obj)) continue;
            key.readerClass = Void.class;
            key.template = Void.class;
            key.obj = placeholder;
        }
        mediaTypeMap.getClassCache().clear();
    }
}

