/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.gitlfs.internal;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import org.sonatype.nexus.repository.gitlfs.internal.GitLfsCoordinate;
import org.sonatype.nexus.repository.gitlfs.internal.GitLfsOperation;
import org.sonatype.nexus.repository.gitlfs.internal.GitLfsTransfer;

@JsonIgnoreProperties(ignoreUnknown=true)
public class GitLfsBatchRequest {
    private static final List<GitLfsTransfer> DEFAULT_TRANSFERS = Collections.unmodifiableList(Collections.singletonList(GitLfsTransfer.BASIC));
    private final GitLfsOperation operation;
    private final List<GitLfsTransfer> transfers;
    private final List<GitLfsCoordinate> objects;

    public GitLfsBatchRequest(GitLfsOperation operation, List<GitLfsTransfer> transfers, List<GitLfsCoordinate> objects) {
        this.operation = (GitLfsOperation)Preconditions.checkNotNull((Object)operation);
        this.transfers = Collections.unmodifiableList((List)Preconditions.checkNotNull(transfers));
        this.objects = Collections.unmodifiableList((List)Preconditions.checkNotNull(objects));
    }

    public GitLfsOperation getOperation() {
        return this.operation;
    }

    public List<GitLfsTransfer> getTransfers() {
        return this.transfers;
    }

    public List<GitLfsCoordinate> getObjects() {
        return this.objects;
    }

    @JsonCreator
    public static GitLfsBatchRequest fromJson(@JsonProperty(value="operation", required=true) GitLfsOperation operation, @JsonProperty(value="transfers", required=false) @Nullable List<GitLfsTransfer> transfers, @JsonProperty(value="objects", required=true) List<GitLfsCoordinate> objects) {
        Preconditions.checkNotNull((Object)operation);
        Preconditions.checkNotNull(objects);
        return new GitLfsBatchRequest(operation, GitLfsBatchRequest.maybeDefaultTransfers(transfers), objects);
    }

    private static List<GitLfsTransfer> maybeDefaultTransfers(@Nullable List<GitLfsTransfer> transfers) {
        if (transfers == null || transfers.isEmpty()) {
            return DEFAULT_TRANSFERS;
        }
        return transfers;
    }
}

