/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.gitlfs.internal;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.InputStream;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.repository.gitlfs.internal.GitLfsBatchRequest;
import org.sonatype.nexus.repository.gitlfs.internal.GitLfsRequestException;

@Named
@Singleton
public class GitLfsBatchRequestParser
extends ComponentSupport {
    private final ObjectMapper mapper = new ObjectMapper();

    public GitLfsBatchRequest parse(InputStream is) {
        Preconditions.checkNotNull((Object)is);
        try {
            return (GitLfsBatchRequest)this.mapper.readValue(is, GitLfsBatchRequest.class);
        }
        catch (JsonProcessingException e) {
            throw new GitLfsRequestException("Cannot process JSON for Git LFS request: " + e.getOriginalMessage(), e);
        }
        catch (IOException e) {
            throw new GitLfsRequestException("IO error reading JSON for Git LFS request", e);
        }
    }
}

