/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.gitlfs.internal;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import javax.annotation.Nonnull;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.shiro.authz.AuthorizationException;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.repository.IllegalOperationException;
import org.sonatype.nexus.repository.InvalidContentException;
import org.sonatype.nexus.repository.gitlfs.internal.GitLfsJsonUtils;
import org.sonatype.nexus.repository.gitlfs.internal.GitLfsRequestException;
import org.sonatype.nexus.repository.view.Context;
import org.sonatype.nexus.repository.view.Handler;
import org.sonatype.nexus.repository.view.Payload;
import org.sonatype.nexus.repository.view.Response;
import org.sonatype.nexus.repository.view.Status;
import org.sonatype.nexus.repository.view.payloads.StringPayload;

@Named
@Singleton
class GitLfsExceptionHandler
extends ComponentSupport
implements Handler {
    private final ObjectMapper mapper = new ObjectMapper();

    GitLfsExceptionHandler() {
    }

    @Nonnull
    public Response handle(@Nonnull Context context) throws Exception {
        String action = context.getRequest().getAction();
        String path = context.getRequest().getPath();
        try {
            return context.proceed();
        }
        catch (IllegalOperationException e) {
            this.log.warn("Illegal operation: {} {}: {}", new Object[]{action, path, e.toString()});
            return this.buildResponse(403, e.getMessage());
        }
        catch (InvalidContentException e) {
            this.log.warn("Invalid content: {} {}: {}", new Object[]{action, path, e.toString()});
            if ("PUT".equals(action)) {
                return this.buildResponse(400, e.getMessage());
            }
            return this.buildResponse(404, e.getMessage());
        }
        catch (GitLfsRequestException e) {
            this.log.warn("Invalid request: {} {}: {}", new Object[]{action, path, e.toString()});
            return this.buildResponse(422, e.getMessage());
        }
        catch (AuthorizationException e) {
            throw e;
        }
        catch (Exception e) {
            this.log.warn("Service failure", (Throwable)e);
            return this.buildResponse(500, "Internal server error");
        }
    }

    private Response buildResponse(int code, String message) throws JsonProcessingException {
        return new Response.Builder().status(Status.failure((int)code, null)).payload((Payload)new StringPayload(this.mapper.writeValueAsString(GitLfsJsonUtils.buildBatchResponse(message)), "application/vnd.git-lfs+json")).build();
    }
}

